<?php
/*
Plugin Name: WPLMS Customizer Plugin
Plugin URI: http://www.Vibethemes.com
Description: A simple WordPress plugin to modify WPLMS template
Version: 1.0
Author: VibeThemes
Author URI: http://www.vibethemes.com
License: GPL2
*/
/*
Copyright 2014  VibeThemes  (email : vibethemes@gmail.com)

wplms_customizer program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License, version 2, as 
published by the Free Software Foundation.

wplms_customizer program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with wplms_customizer program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


include_once 'classes/customizer_class.php';



if(class_exists('WPLMS_Customizer_Plugin_Class'))
{	
    // instantiate the plugin class
    $wplms_customizer = new WPLMS_Customizer_Plugin_Class();
}

add_filter('wplms_take_course_button_html','custom_non_loggedin_user_redirect',10,2);
add_filter('wplms_course_non_loggedin_user','custom_non_loggedin_user_redirect',10,2);
add_filter('wplms_private_course_button_html','custom_non_loggedin_user_redirect',10,2);

function custom_non_loggedin_user_redirect($html,$course_id){
  if(!is_user_logged_in()){
    $extra ='';    
    $page = 'https://gutti.pe/register';
    return '<a href="'.$page.'" class="course_button full button">'.apply_filters('wplms_take_this_course_button_label',__('TAKE THIS COURSE','vibe'),$course_id).apply_filters('wplms_course_button_extra',$extra,$course_id).'</a>'; 
  }
  return $html;
}

add_action( 'template_redirect', 'wc_custom_redirect_after_purchase' ); 
function wc_custom_redirect_after_purchase() {
  global $wp;
  
  if ( is_checkout() && ! empty( $wp->query_vars['order-received'] ) ) {
    wp_redirect( get_permalink( get_option('woocommerce_myaccount_page_id') ) );
    exit;
  }
}

add_filter('gettext', 'avada_kedavara', 20, 3);
function avada_kedavara($translated_text, $untranslated_text, $domain) {
if ( $untranslated_text == 'COMPLETE SIGN UP') {
return 'BRO YOU ARE A PRO.';
}
return $translated_text;

}
