<?php
/**
 * Admin functions and actions.
 *
 * @author 		VibeThemes
 * @category 	Admin
 * @package 	wplms-mc/Includes
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Wplms_Mailchimp_Admin{

	public static $instance;
    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new Wplms_Mailchimp_Admin();
        return self::$instance;
    }

	private function __construct(){
		$this->init = Wplms_Mailchimp_Init::init();
		$this->settings = $this->init->settings;
		add_action( 'admin_notices', array( $this, 'show_admin_notices' ), 10 );
		add_filter('wplms_lms_settings_tabs',array($this,'setting_tab'));
		add_filter('lms_settings_tab',array($this,'tab'));

	}

	function show_admin_notices(){

	}

	function setting_tab($tabs){
		$tabs['wplms-mailchimp'] = __('Mailchimp','wplms-mc');
		return $tabs;
	}

	function tab($name){
		if($name == 'wplms-mailchimp')
			return 'wplms_mailchimp_settings';
		return $name;
	}

	function get_settings(){

		if(!empty($this->settings)){
			if(empty($this->settings['company']) || empty($this->settings['from_email']) || empty($this->settings['permission_reminder']) || empty($this->settings['language'])){
				$list_creation_button = __('Enter List creation details','wplms-mc');
			}else{
				$list_creation_button = __('Click to Create/Sync Lists','wplms-mc');
			}
		}else{
			$list_creation_button = __('Enter List creation details','wplms-mc');
		}
		
		return apply_filters('wplms_mailchimp_settings',array(
			array(
				'label' => __( 'MailChimp API Key', 'wplms-mc' ),
				'name' => 'mailchimp_api_key',
				'type' => 'text',
				'desc' => sprintf(__( 'How to get MailChimp API Key %s Tutorial %s', 'wplms-mc' ),'<a href="http://kb.mailchimp.com/integrations/api-integrations/about-api-keys" target="_blank">','</a>'),
			),
			array(
				'label' => __( 'All Users List, also adds enable Subscribe option in Registration ', 'wplms-mc' ),
				'name' => 'enable_registration',
				'type' => 'mailchimp_lists',
				'desc' => __( 'All users signing up via Registration see an option to signup for the newsletter.', 'wplms-mc' ),
			),
			array(
				'label' => __( 'Enable Subscribe option in WooCommerce Checkout', 'wplms-mc' ),
				'name' => 'enable_woo_subscription',
				'type' => 'mailchimp_lists',
				'desc' => __( 'All users purchasing any course or signing up via WooCommerce see an option to signup for the newsletter.', 'wplms-mc' ),
			),
			array(
				'label' => __( 'All Courses Students List', 'wplms-mc' ),
				'name' => 'all_course_students',
				'type' => 'mailchimp_lists',
				'desc' => __( 'All users signing up via WooCommerce see an option to signup for the newsletter.', 'wplms-mc' ),
			),
			array(
				'label' => __( 'Enable Course specific Group Name for All Courses list (Blank to disable)', 'wplms-mc' ),
				'name' => 'course_group',
				'type' => 'text',
				'desc' => __( 'Enter the Group name for Course specific groups', 'wplms-mc' ),
			),
			array(
				'label' => __( 'Create Course specific lists', 'wplms-mc' ),
				'name' => 'course_list',
				'type' => 'checkbox',
				'desc' => sprintf(__( '%s %s %s , To create a list for every course, list creation details must be saved. reload the page after saving details. ', 'wplms-mc' ),'<a id="sync_course_lists_now" class="button"><span></span>',$list_creation_button,'</a>'),
			),
			array(
				'label' => __( 'Company name (Required for list creation)', 'wplms-mc' ),
				'name' => 'company',
				'type' => 'text',
				'desc' => __( 'Enter company name', 'wplms-mc' ),
			),
			array(
				'label' => __( 'Company Address (Required for list creation)', 'wplms-mc' ),
				'name' => 'company_address',
				'type' => 'text',
				'desc' => __( 'Enter company address', 'wplms-mc' ),
			),
			array(
				'label' => __( 'Company City (Required for list creation)', 'wplms-mc' ),
				'name' => 'company_city',
				'type' => 'text',
				'desc' => __( 'Enter company city', 'wplms-mc' ),
			),
			array(
				'label' => __( 'Company State (Required for list creation)', 'wplms-mc' ),
				'name' => 'company_state',
				'type' => 'text',
				'desc' => __( 'Enter company address', 'wplms-mc' ),
			),
			array(
				'label' => __( 'Company Zipcode/Pincode (Required for list creation)', 'wplms-mc' ),
				'name' => 'company_zip',
				'type' => 'text',
				'desc' => __( 'Enter company address', 'wplms-mc' ),
			),
			array(
				'label' => __( 'Company country (Required for list creation)', 'wplms-mc' ),
				'name' => 'company_country',
				'type' => 'text',
				'desc' => __( 'Enter company address', 'wplms-mc' ),
			),
			array(
				'label' => __( 'Permission reminder (Required for list creation)', 'wplms-mc' ),
				'name' => 'permission_reminder',
				'type' => 'text',
				'desc' => sprintf(__( 'Enter a permission reminder, why you are getting this email to the user. %s more details %s', 'wplms-mc' ),'<a href="http://kb.mailchimp.com/accounts/compliance-tips/edit-the-permission-reminder">','</a>')
			),
			array(
				'label' => __( 'From Name (Required for list creation)', 'wplms-mc' ),
				'name' => 'from_name',
				'type' => 'text',
				'desc' => __('Default From name for List campaigns','wplms-mc')
			),
			array(
				'label' => __( 'From Email (Required for list creation)', 'wplms-mc' ),
				'name' => 'from_email',
				'type' => 'text',
				'desc' => __('Default From email for List campaigns, use custom domain emails for best performance, example admin@yoursite.com','wplms-mc')
			),
			array(
				'label' => __( 'Subject (Required for list creation)', 'wplms-mc' ),
				'name' => 'subject',
				'type' => 'text',
				'desc' => __('Default Subject for List campaigns','wplms-mc')
			),
			array(
				'label' => __( 'Language Code (Required for list creation)', 'wplms-mc' ),
				'name' => 'language',
				'type' => 'text',
				'desc' => sprintf(__('Set a default Language code for List campaigns %s See Language code List %s','wplms-mc'),'<a href="http://kb.mailchimp.com/lists/managing-subscribers/view-and-edit-subscriber-languages#code" target="_blank" class="button">','</a>'),
			),
			array(
				'label' => __( 'Enable Course Status Group Name for Course specific Lists (Blank to disable)', 'wplms-mc' ),
				'name' => 'course_status_group',
				'type' => 'text',
				'desc' => __( 'Enables different groups for Course Statuses, Start/Continue, Fisnihed & Expired Users will have different lists. Enter the group name for Course Statuses for Course specific Lists.', 'wplms-mc' ),
			),
			array(
				'label' => __( 'Enable Course Active (Active/expired) Group Name (Blank to disable)', 'wplms-mc' ),
				'name' => 'course_expiry_group',
				'type' => 'text',
				'desc' => __( 'Enables different groups for Active course students and Expired course students.', 'wplms-mc' ),
			),
			array(
				'label' => __( 'Auto-Subscribe/unsubscribe user on Course subscribe/unsubscribe, Auto switch between List groups', 'wplms-mc' ),
				'name' => 'auto_course_list_subscribe',
				'type' => 'checkbox',
				'desc' => _x( 'Auto-Subscribe user to course list on course subscription. Auto-remove user from Course when user is removed from the course. Auto','WPLMS Mailchimp setting', 'wplms-mc'),
			),
			array(
				'label' => __( 'All Instructors list', 'wplms-mc' ),
				'name' => 'all_instructors_list',
				'type' => 'mailchimp_lists',
				'desc' => __( 'All users signing up via WooCommerce see an option to signup for the newsletter.', 'wplms-mc' ),
			),
			array(
				'label' => __( 'Google reCaptcha Key', 'wplms-mc' ),
				'name' => 'recaptcha_key',
				'type' => 'text',
				'desc' => sprintf(__( '* Required only for reCaptcha in widgets, %s Learn how to get reCaptcha key %s', 'wplms-mc' ),'<a href="https://developers.google.com/recaptcha/docs/start" target="_blank">','</a>'),
			),
			array(
				'label' => __( 'Google reCaptcha Secret', 'wplms-mc' ),
				'name' => 'recaptcha_secret',
				'type' => 'text',
				'desc' => sprintf(__( '* Required only for reCaptcha in widgets, %s Learn how to get reCaptcha secret %s', 'wplms-mc' ),'<a href="https://developers.google.com/recaptcha/docs/start" target="_blank">','</a>'),
			),
			array(
				'label' => __( 'Auto Sync Lists', 'wplms-mc' ),
				'name' => 'auto_sync_lists',
				'type' => 'select',
				'options'=>array(
					''=>__('Manual Sync','wplms-cc'),
					'daily'=>__('Every Day','wplms-cc'),
				),
				'desc' => __( 'Sync all Lists,', 'wplms-mc' ),
			),
		));	
	}
	function settings(){

		echo '<form method="post">';
		wp_nonce_field('wplms_mailchimp_settings');   
		echo '<table class="form-table">
				<tbody>';

		$settings = $this->get_settings();

		$this->generate_form($settings);
		if(isset($_GET['batch'])){
			$mc = new Wplms_Mailchimp($this->init->settings['mailchimp_api_key']);
			print_r($mc->get_batch_status($_GET['batch']));	
		}
		
		?>

		<?php
		echo '<tr valign="top"><th colspan="2"><input type="submit" name="save_wplms_mailchimp_settings" class="button button-primary" value="'.__('Save Settings','wplms-mc').'" /></th>';
		echo '</tbody></table></form>'; ?><style>#sync_course_lists_now span,.sync_lists span{padding:0;} .sync_lists,#sync_course_lists_now{position:relative;}.sync_lists.active,#sync_course_lists_now.active{color: rgba(255,255,255,0.2);} #sync_course_lists_now.active span,.sync_lists.active span{position:absolute;left:0;top:0;width:0;transition: width 1s;height:100%;background:#009dd8;text-align: center;color: #fff;}.company,.company_address,.company_country,.company_zip,.company_state,.company_city,.permission_reminder,.from_name,.from_email,.subject,.language{display:none;}</style><script>

			function isJson(str) {

				if(str == null)
					return false;

			    try {
			        JSON.parse(str);
			    } catch (e) {
			        return false;
			    }
			    if(Object.keys(str).length === 0 && str.constructor === Object){
			    	return false;
			    }


			    return true;
			}
			jQuery(document).ready(function($){

				$("body").on('click','.sync_lists',function(event){
					event.preventDefault();
					var $this = $(this);
					if($this.hasClass('active')){return;}
					$this.addClass('active');
					$this.find('span').css('width','10%');
					$.ajax({
                      	type: 	"POST",
                      	url: 	ajaxurl,
                      	data: { action: 'sync_lists_get', //Fetches from 
                              	security: $('#_wpnonce').val(),
                              	list:$('select[name="'+$this.attr('id')+'"]').val(),
                            },
                      	cache: false,
                      	success:function(json){ 
                      		$this.find('span').css('width','40%'); 
                      		$.ajax({
		                      	type: 	"POST",
		                      	url: 	ajaxurl,
		                      	data: { action: 'sync_lists_put', 
		                              	security: $('#_wpnonce').val(),
		                              	emails:JSON.stringify(json),
		                              	element:$this.attr('id'),
		                              	list:$('select[name="'+$this.attr('id')+'"]').val(),
		                              	course_group:$('input[name="course_group"]').val(),
		                            },
		                        cache: false,
		                      	success: function (html) {
		                      		if(isJson(html)){ 

		                      			ajaxcalls = $.parseJSON(html);
		                      			if(ajaxcalls.length){
											var json = ajaxcalls[0];
											var data = getData(json,0);
											for (var i = 1; i < ajaxcalls.length; i++) {
											    // Or only the last "i" will be used
											    (function (i) {
											        data = data.then(function() {
											            return getData(ajaxcalls[i],i);
											        });
											    }(i));
											}

											// Also, see how better the getData can be.
											function getData(json,key) {
												console.log(key);
												console.log(ajaxcalls.length);
												console.log((key+1/ajaxcalls.length));
											    return 	$.ajax({
									                      	type: "POST",
									                      	url: ajaxurl,
									                      	data: json,
									                      	success:function(j){

									                      		var width = 40+(((key+1)/ajaxcalls.length)*60);
									                      		console.log(width);

									                      		if(width >=100){
									                      			width = 99;
									                      		}
									                      		$this.find('span').css('width',width+'%');
									                      		if((key+1) == ajaxcalls.length ){
									                      			$this.find('span').css('width','100%');
									                      			$this.find('span').text('Sync Complete');
										                      		setTimeout(function(){
										                      			$this.removeClass('active');$this.find('span').text('');
										                      			$this.find('span').css('width','0%');
										                      		},2000);
									                      		}
									                      	}
								                      	}).done(function(d) {
														        var response = d;
														    }).fail(function() {
														        alert('ERROR');
														    });
											}
		                      			}
		                      		}else{
		                      			$this.find('span').css('width','100%');
			                      		$this.find('span').text('Sync Complete');
			                      		setTimeout(function(){
			                      			$this.removeClass('active');$this.find('span').text('');
			                      			$this.find('span').css('width','0%');
			                      		},2000);
		                      		}
		                      	}
	                      	}); 
                		}
					});
				});
				$('#sync_course_lists_now').on('click',function(event){
					if(!$(this).hasClass('filled')){
						event.preventDefault();
						$('.company,.company_address,.company_country,.company_zip,.company_state,.company_city,.permission_reminder,.from_email,.subject,.from_name,.language').toggle(200);
						if(!$(this).hasClass('filled')){
							$(this).addClass('filled button-primary');

						}
					}else{
				
					var $this = $(this);
					if($this.hasClass('active')){return;}

					var cname =$('input[name="company"]').val();
					var caddress =$('input[name="company_address"]').val();
					var ccity =$('input[name="company_city"]').val();
					var cstate =$('input[name="company_state"]').val();
					var ccountry =$('input[name="company_country"]').val();
					var czip =$('input[name="company_zip"]').val();
					var fname =$('input[name="from_name"]').val();
					var femail =$('input[name="from_email"]').val();
					var language =$('input[name="language"]').val();
					var permission_reminder =$('input[name="permission_reminder"]').val();
				    if (!cname || !caddress || !ccity || !cstate || !ccountry || !czip || !permission_reminder || !fname || !femail || !language){
				      alert("Please fill all the required fields for List creation in Mailchimp");
				      return false;
				    }

				    $this.addClass('active');
					$this.find('span').css('width','10%');
					$.ajax({
                      	type: 	"POST",
                      	url: 	ajaxurl,
                      	dataType: "json",
                      	data: { action: 'get_create_course_lists', //Fetches from 
                              	security: $('#_wpnonce').val(),
                            },
                      	cache: false,
                      	success:function(json){
                      		$this.find('span').css('width','40%'); 
	                      		$.ajax({
			                      	type: 	"POST",
			                      	url: 	ajaxurl,
			                      	data: { action: 'course_lists_put', 
			                              	security: $('#_wpnonce').val(),
			                              	data:JSON.stringify(json),
			                              	status_group:$('input[name="course_status_group"]').val(),
			                              	expiry_group:$('input[name="course_expiry_group"]').val(),
			                            },
			                        cache: false,
			                      	complete: function (html) {
			                      		$this.find('span').css('width','100%');
			                      		$this.find('span').text('Sync Complete');
			                      		setTimeout(function(){
			                      			$this.removeClass('active');$this.find('span').text('');
			                      			$this.find('span').css('width','0%');
			                      		},2000);
			                      	}
		                      	}); 
                		}
					});
				}
				});
			});
			</script>
			<?php
	}

	function generate_form($settings){
		
		foreach($settings as $setting ){
			echo '<tr valign="top" class="'.$setting['name'].'">';
			switch($setting['type']){
				case 'textarea':
					echo '<th scope="row" class="titledesc"><label>'.$setting['label'].'</label></th>';
					echo '<td class="forminp"><textarea name="'.$setting['name'].'" style="max-width: 560px; height: 240px;border:1px solid #DDD;">'.(isset($this->settings[$setting['name']])?$this->settings[$setting['name']]:'').'</textarea>';
					echo '<span>'.$setting['desc'].'</span></td>';
				break;
				case 'select':
					echo '<th scope="row" class="titledesc"><label>'.$setting['label'].'</label></th>';
					echo '<td class="forminp"><select name="'.$setting['name'].'">';
					foreach($setting['options'] as $key=>$option){
						echo '<option value="'.$key.'" '.(isset($this->settings[$setting['name']])?selected($key,$this->settings[$setting['name']]):'').'>'.$option.'</option>';
					}
					echo '</select>';
					echo '<span>'.$setting['desc'].'</span></td>';
				break;
				case 'checkbox':
					echo '<th scope="row" class="titledesc"><label>'.$setting['label'].'</label></th>';
					echo '<td class="forminp"><input type="checkbox" name="'.$setting['name'].'" '.(isset($this->settings[$setting['name']])?'CHECKED':'').' />';
					echo '<span>'.$setting['desc'].'</span>';
				break;
				case 'number':
					echo '<th scope="row" class="titledesc"><label>'.$setting['label'].'</label></th>';
					echo '<td class="forminp"><input type="number" name="'.$setting['name'].'" value="'.(isset($this->settings[$setting['name']])?$this->settings[$setting['name']]:$setting['std']).'" />';
					echo '<span>'.$setting['desc'].'</span></td>';
				break;
				case 'text':
					echo '<th scope="row" class="titledesc"><label>'.$setting['label'].'</label></th>';
					echo '<td class="forminp"><input type="text" name="'.$setting['name'].'" value="'.(isset($this->settings[$setting['name']])?$this->settings[$setting['name']]:$setting['std']).'" />';
					echo '<span>'.$setting['desc'].'</span></td>';
				break;
				case 'mailchimp_lists':
					echo '<th scope="row" class="titledesc"><label>'.$setting['label'].'</label></th>';
					echo '<td class="forminp"><select name="'.$setting['name'].'">
					<option value="">'._x('Disable','disable switch in WPLMS Mailchimp settings','wplms-mc').'</option>';
					$mc_lists = $this->init->get_lists();
					foreach($mc_lists as $key=>$option){
						echo '<option value="'.$key.'" '.(isset($this->settings[$setting['name']])?selected($key,$this->settings[$setting['name']]):'').'>'.$option.'</option>';
					}
					echo '</select><a id="'.$setting['name'].'" class="button sync_lists"><span></span>'.__('Sync all Users','wplms-cc').'</a>';
					echo '<span>'.$setting['desc'].'</span></td>';
				break;
			}
		}	
	}
	/*a#enable_registration:before { position: absolute; content: ''; width: 10%; background: #009dd8; left: 0; top: 0; height: 100%; z-index: 2; border-radius: 2px; } a#enable_registration:after { position: absolute; content: ''; width: 100%; left: 0; top: 0; height: 100%; background: rgba(255,255,255,0.8); border-radius: 2px; z-index: 1; }*/
	function save(){
		

		if(!isset($_POST['save_wplms_mailchimp_settings']))
			return;

		if ( !isset($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'],'wplms_mailchimp_settings') ){
		     echo '<div class="error notice is-dismissible"><p>'.__('Security check Failed. Contact Administrator.','wplms-mc').'</p></div>';
		}

		$settings = $this->get_settings();
		foreach($settings as $setting){
			if(isset($_POST[$setting['name']])){
				$this->settings[$setting['name']] = $_POST[$setting['name']];
			}else if($setting['type'] == 'checkbox' && isset($this->settings[$setting['name']])){
				unset($this->settings[$setting['name']]);
			}
		}

		update_option(WPLMS_MAILCHIMP_OPTION,$this->settings);
		echo '<div class="updated notice is-dismissible"><p>'.__('Settings Saved.','wplms-mc').'</p></div>';
	}

}

add_action('admin_init','wplms_mailchimp_admin_initialise');
function wplms_mailchimp_admin_initialise(){
	Wplms_Mailchimp_Admin::init();	
}

function wplms_mailchimp_settings(){
	$init = Wplms_Mailchimp_Admin::init();
	$init->save();
	$init->settings();
}