<?php
/**
 * Admin functions and actions.
 *
 * @author 		VibeThemes
 * @category 	Admin
 * @package 	Wplms-S3/Includes
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class Wplms_Mailchimp_Init{

	/*
	Stores all lists
	 */
	public $lists = array();
	/*
	Stores emails from list id List ID => Member emails
	 */
	public $list_members = array();

	public static $instance;
    
    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new Wplms_Mailchimp_Init();
        return self::$instance;
    }

	private function __construct(){
		$this->settings = get_option(WPLMS_MAILCHIMP_OPTION);
		$this->loop_max = 99;

		if(!empty($this->settings)){
			if(isset($this->settings['enable_registration'])){
				add_action('bp_signup_validate', array($this,'add_subscribe_mailchimp'));
				add_action('bp_before_registration_submit_buttons', array($this,'display_subscribe_checkbox'),9,1);
			}
			if(isset($this->settings['enable_woo_subscription'])){ 
				add_action('woocommerce_review_order_before_submit',array($this,'display_subscribe_checkbox'),10);
				add_action('woocommerce_new_order',array($this,'check_if_enabled'),10,1);
				add_action( 'woocommerce_order_status_completed',array($this, 'add_student_to_subscribe_list' ),1,1);
			}
			if(isset($this->settings['course_list'])){
				add_filter('wplms_course_metabox',array($this,'wplms_course_lists'));
			}
			if(isset($this->settings['auto_course_list_subscribe'])){
				add_filter('wplms_course_subscribed',array($this,'add_to_list'),10,2);	
				add_filter('wplms_course_unsubscribe',array($this,'remove_from_list'),10,2);
				if(!empty($this->settings['course_status_group']))	
					add_filter('wplms_evaluate_course',array($this,'change_status'),10,3);	
			}
			if(!empty($this->settings['auto_sync_lists'])){
				/*
				TEST HOOK : Comment in the clear_sheduled_hook line and set time()+60
				Install the WP Cron view plugin and check the time of the cron
				 */
				//wp_clear_scheduled_hook('wplms_mailchimp_sync_lists');
				if (! wp_next_scheduled ( 'wplms_mailchimp_sync_lists' )) {
					wp_schedule_event(time(), $this->settings['auto_sync_lists'], 'wplms_mailchimp_sync_lists');
				}
				add_action('wplms_mailchimp_sync_lists',array($this,'sync_lists'));
			}
		}
		
		/* AJAX FUNCTIONS */
		add_action('wp_ajax_sync_lists_get',array($this,'sync_lists_get'));
		add_action('wp_ajax_sync_lists_put',array($this,'sync_lists_put'));
		add_action('wp_ajax_get_create_course_lists',array($this,'get_create_course_lists'));
		add_action('wp_ajax_course_lists_put',array($this,'course_lists_put'));
		/* Subscribe Widget */
		add_action('wp_ajax_wplms_mc_subscribe_to_list',array($this,'wplms_mc_subscribe_to_list'));

		//Add mailchimp in custom registration form
		add_filter('wplms_registration_form_settings',array($this,'wplms_add_mailchimp_list_in_custom_registration_form'));
		add_action('wplms_before_registration_form',array($this,'wplms_add_mailchimp_checkbox_on_registration'));
		add_action('wplms_custom_registration_form_user_added',array($this,'wplms_add_user_to_mailchimp_list_on_registration'),10,3);
	}

	function show_admin_notices(){

	}

	function get_literals(){

		return apply_filters('wplms_mailchimp_literals',array(
			'pursuing'=>_x('pursuing','small case mailchimp course status label','wplms-mc'),
			'finished'=>_x('finished','small case mailchimp course status label','wplms-mc'),
			'active'=>_x('active','small case mailchimp course status label','wplms-mc'),
			'expired'=>_x('expired','small case mailchimp course status label','wplms-mc'),
			));
	}

	function get_lists(){
		$lists = array();
		if(!empty($this->lists))
			return $this->lists;

		if(isset($this->settings) && isset($this->settings['mailchimp_api_key'])){
			$mc = new Wplms_Mailchimp($this->settings['mailchimp_api_key']);
			$lists = $mc->get_lists();
			if(!empty($lists) && isset($lists->lists)){
				foreach($lists->lists as $list){
					$this->lists[$list->id]=$list->name;
				}
			}
		}
		return $this->lists;
	}

	function display_subscribe_checkbox(){
		echo '<div class="mailchimp_subscribe_checkbox" style="margin:15px 0;"><div class="checkbox">
        <input type="checkbox" name="subscribe_mailchimp" id="subscribe_mailchimp" value="1" checked> <label for="subscribe_mailchimp">'._x('Subscribe to our newsletter','Mailchimp subscribe checkbox in Buddypress registration form','wplms-mc').'</label>  
        </div></div>';
	}

	function add_subscribe_mailchimp(){
		global $bp;

		if(empty($_POST['subscribe_mailchimp']))
			return;

        if (!empty($_POST['subscribe_mailchimp']) && empty($bp->signup->errors)) {
            
            if(isset($this->settings) && isset($this->settings['mailchimp_api_key']) && !empty($_POST['signup_email']) && !empty($this->settings['enable_registration'])){
				$mc = new Wplms_Mailchimp($this->settings['mailchimp_api_key']);
				$args = apply_filters('wplms_mailchimp_list_filters',array('email_address'=>$_POST['signup_email']),$_POST);
				$return = $mc->mailchimp_list_function($args,$this->settings['enable_registration'],'subscribed');
				if(empty($return)){
					add_filter('the_content',function($content){ $content .='<div class="message success">'._x('You\'re subscribed to our newsletter','Success message on mail subscription','wplms-mc').'</div>'; return $return;});
				}else{
					add_filter('the_content',function($content){ $content.='<div class="message">'.$return.'</div>';return $return;});
				}
			}
        }
        return;
	}
	
	function check_if_enabled($order_id){
		if(!empty($_POST['subscribe_mailchimp'])){
			update_post_meta( $order_id, '_subscribe_wplms_mailchimp', 'yes' );
		}
	}

	function add_student_to_subscribe_list($order_id){
		if(empty($this->settings['mailchimp_api_key']) || empty($this->settings['enable_woo_subscription']))
			return;
		$check = get_post_meta($order_id, '_subscribe_wplms_mailchimp',true);
		if(!empty($check)){
			$order = new WC_Order( $order_id );
			$user = $order->get_user();
		    if ( !empty($user)){ 
		        $mc = new Wplms_Mailchimp($this->settings['mailchimp_api_key']);
		        $args = apply_filters('wplms_mailchimp_list_filters',array('email_address'=>$user->user_email,'merge_fields'=>array('FNAME'=>$user->first_name,'LNAME'=>$user->last_name)),$user);
		        $return = $mc->mailchimp_list_function($args,$this->settings['enable_woo_subscription'],'subscribed');
		    }
		}
	}

	function sync_lists_get(){
		if ( !isset($_POST['security']) || !wp_verify_nonce($_POST['security'],'wplms_mailchimp_settings') ){
		     echo '<div class="error notice is-dismissible"><p>'.__('Security check Failed. Contact Administrator.','wplms-mc').'</p></div>';
		}
		$mc = new Wplms_Mailchimp($this->settings['mailchimp_api_key']);
		$emails = $mc->get_all_emails_from_list($_POST['list']);
		print_r(json_encode($emails));
		die();
	}

	function sync_get_interests(){
		if ( !isset($_POST['security']) || !wp_verify_nonce($_POST['security'],'wplms_mailchimp_settings') ){
		     echo '<div class="error notice is-dismissible"><p>'.__('Security check Failed. Contact Administrator.','wplms-mc').'</p></div>';
		}
		$mc = new Wplms_Mailchimp($this->settings['mailchimp_api_key']);
		$interests = $mc->get_list_interest_categories($_POST['list']);
		print_r($interests);
		die();
	}

	function sync_lists_put(){
		if ( !isset($_POST['security']) || !wp_verify_nonce($_POST['security'],'wplms_mailchimp_settings') ){
		     echo '<div class="error notice is-dismissible"><p>'.__('Security check Failed. Contact Administrator.','wplms-mc').'</p></div>';
		     die();
		}
		$emails = json_decode(stripcslashes($_POST['emails']));

		$all_emails = array();
		if(!empty($emails)){
			foreach($emails as $email){
				$all_emails[]=$email->email;
			}	
		}

		if($_POST['element'] == 'all_course_students' && !isset($_POST['paged'])){
			//Get all students;
			global $wpdb;
			$results = $wpdb->get_results("SELECT user_id FROM {$wpdb->usermeta} WHERE meta_key LIKE 'course_status%' GROUP BY user_id");

			$total_count = count($results);
			if($total_count > $this->loop_max){
			//Run loop in batches of 100;
				for($i=0;$i<$total_count;$i=$i+$this->loop_max){
					$return_chained_ajax[]=array(
						'action'=> 'sync_lists_put', 
	                  	'security'=> $_POST['security'],
	                  	'emails'=> $_POST['emails'],
	                  	'element'=> $_POST['element'],
	                  	'list'=> $_POST['list'],
	                  	'paged'=> $i,
	                  	'course_group'=> $_POST['course_group']
					);
				}
				echo json_encode($return_chained_ajax);
				die();
			}
		}

		if(isset($_POST['paged'])){
			$paged = $_POST['paged'];
		}else{
			$paged = 0;
		}

		$this->sync_lists_put_check($all_emails,$_POST['element'],$_POST['list'],$_POST['course_group'],$paged);
		die();
	}

	function sync_lists_put_check($all_emails,$element,$list,$course_group = NULL,$paged=0){
		
		$mc = new Wplms_Mailchimp($this->settings['mailchimp_api_key']);
		global $wpdb;
		switch($element){
			case 'enable_registration':
				$all_users = $wpdb->get_results("SELECT user_email,display_name FROM {$wpdb->users} WHERE user_status = 0");
				$all_user_mails = array();
				$merge_fields = array();
				if(!empty($all_users)){
					foreach($all_users as $user){
						$all_user_mails[] = $user->user_email;
						$mfields = explode(' ',$user->display_name);
						$fname = $mfields[0];
						$lname = '';
						if(!empty($mfields[1])){
							$lname = $mfields[1];
						}
						$merge_fields[$user->user_email] = array('FNAME'=>$fname,'LNAME'=>$lname);
					}
				}
				$tobe_rejected_mails =  array_diff($all_emails, $all_user_mails);
				$tobe_added_mails =  array_diff($all_user_mails,$all_emails);
				
				$mc->bulk_add_remove_emails($list,$tobe_added_mails,$tobe_rejected_mails,$merge_fields);
			break;
			case 'enable_woo_subscription':
	            
				$all_users = $wpdb->get_results("SELECT  m.meta_value as email,p.ID as order_id FROM {$wpdb->postmeta} as m LEFT JOIN {$wpdb->posts} as p ON m.post_id = p.ID WHERE p.post_type = 'shop_order' AND p.post_status = 'wc-completed' AND m.meta_key = '_billing_email' GROUP BY email LIMIT $paged,$this->loop_max");
				$all_user_mails = array();
				$merge_fields = array();
				if(!empty($all_users)){
					foreach($all_users as $user){
						$all_user_mails[] = $user->email;
						$fname   = get_post_meta( $user->order_id, '_billing_first_name',true);
	                	$lname   = get_post_meta( $user->order_id, '_billing_last_name',true);
						$merge_fields[$user->email] = array('FNAME'=>$fname,'LNAME'=>$lname);
					}
				}
				$tobe_rejected_mails =  array_diff($all_emails, $all_user_mails);
				$tobe_added_mails =  array_diff($all_user_mails,$all_emails);
				
				$mc->bulk_add_remove_emails($list,$tobe_added_mails,$tobe_rejected_mails,$merge_fields);
			break;
			case 'all_course_students':

				if(empty($course_group))//Bail out not sync required
					die();

				$interests = $mc->get_list_interest_categories($list);

				$course_group_id = $status_group_id = $expiry_group_id = 0;
				if(!empty($course_group)){
					if(!empty($interests) && in_array($course_group,$interests)){
						$course_group_id = array_search($course_group,$interests);
					}else{
						$course_group_id = $mc->create_interest_categories($list,array('title'=>$course_group,'type'=>'checkboxes'));
						
					}
					
				}
				
				// Running perfectly up til here
				
				$time = time();
				
				$all_users = $wpdb->get_results("SELECT u.user_email as email,
					u.display_name as name,
					p.post_title as course_name
					FROM {$wpdb->users} as u 
					LEFT JOIN {$wpdb->usermeta} as m 
					ON u.ID = m.user_id 
					LEFT JOIN {$wpdb->usermeta} as m2 
					ON u.ID = m2.user_id 
					LEFT JOIN {$wpdb->posts} as p 
					ON m.meta_key = p.ID 
					WHERE u.user_status = 0 
					AND m2.meta_key LIKE '%course_status%'
					AND p.post_type = 'course'
					AND p.post_status = 'publish'
					GROUP BY email, course_name
					LIMIT $paged,$this->loop_max");

				$all_user_mails = array();
				$merge_fields = $member_interests = array();
				
				if(!empty($all_users)){
					foreach($all_users as $user){
						//if(!in_array($user->email,$all_user_mails)){ CHECK FOR ALL EMAILS
							$all_user_mails[] = $user->email;
							$mfields = explode(' ',$user->name);
							$fname = $mfields[0];
							$lname = '';
							if(!empty($mfields[1])){
								$lname = $mfields[1];
							}
							$merge_fields[$user->email] = array('FNAME'=>$fname,'LNAME'=>$lname);

							if(!empty($course_group_id)){
								$ids = $mc->get_interest_category_interest_ids($_POST['list'],$course_group_id);
								$id = array_Search($user->course_name,$ids);
								if(empty($id)){
									$id = $mc->create_interest_category_interest($_POST['list'],$course_group_id,$user->course_name);	
								}
								if(empty($member_interests[$user->email])){
									$member_interests[$user->email] = array($id => true);
								}else{
									$member_interests[$user->email][$id] = true; 
								}
							}
						//}
					}
				}

				$tobe_rejected_mails =  array_diff($all_emails, $all_user_mails);
				$tobe_added_mails =  array_diff($all_user_mails,$all_emails);
				$mc->bulk_add_remove_emails($list,$tobe_added_mails,$tobe_rejected_mails,$merge_fields,$member_interests);
			break;
			case 'all_instructors_list':
				$all_instructors = get_users( 'role=instructor' );
				$all_instructor_mails = array();
				$merge_fields = array();
				if(!empty($all_instructors)){
					foreach($all_instructors as $instructor){
						$all_instructor_mails[] = $instructor->user_email;
						$fname = $instructor->first_name;
						$lname = $instructor->last_name;
						$merge_fields[$instructor->user_email] = array('FNAME'=>$fname,'LNAME'=>$lname);
					}
				}
				$tobe_rejected_mails =  array_diff($all_emails, $all_instructor_mails);
				$tobe_added_mails =  array_diff($all_instructor_mails,$all_emails);
				$mc->bulk_add_remove_emails($list,$tobe_added_mails,$tobe_rejected_mails,$merge_fields);
			break;
		}
	}

	function get_create_course_lists(){

		if ( !isset($_POST['security']) || !wp_verify_nonce($_POST['security'],'wplms_mailchimp_settings') ){
		     echo '<div class="error notice is-dismissible"><p>'.__('Security check Failed. Contact Administrator.','wplms-mc').'</p></div>';
		}
		$mc = new Wplms_Mailchimp($this->settings['mailchimp_api_key']);
		if(empty($this->lists)){
			$this->get_lists();
		}

		global $wpdb;
		//Existing Course List ids
		$course_lists = $wpdb->get_results("SELECT meta_value,post_id FROM {$wpdb->postmeta} WHERE meta_key = 'vibe_wplms_mailchimp_list'");

		$course_list_ids = $exclude_courses = array();
		$ex_list_ids = array_keys($this->lists);
		if(!empty($course_lists)){
			foreach($course_lists as $list){
				if($list->meta_value == 'disable'){
					$exclude_courses[] = $list->post_id;
				}else{
					if(in_array($list->meta_value,$ex_list_ids)){ // Check if list exists
						$course_list_ids[$list->meta_value] = $list->post_id;	
					}
				}
			}
		}

		$extra_q = '';
		if(!empty($exclude_courses)){ 
			$extra_q = ' AND ID NOT IN ('.implode(',',$exclude_courses).')';
		}
		$courses = $wpdb->get_results("SELECT ID,post_title FROM {$wpdb->posts} WHERE post_status = 'publish' AND post_type ='course'$extra_q");

		
		$list_ids = array();
		if(!empty($courses)){
			foreach($courses as $course){
				if(in_array($course->ID,$course_list_ids)){
					$id = array_search($course->ID,$course_list_ids);
					$list_ids[]=array('list_id'=>$id,'list_name'=>$course->post_title);
				}else{
					if(!in_array($course->post_title,$this->lists)){
						$list_args = array(
							'name'=>$course->post_title,
							'contact'=>array(
								'company'=>$this->settings['company'],
								'address1'=>$this->settings['company_address'],
								'city'=>$this->settings['company_city'],
								'state'=>$this->settings['company_state'],
								'zip'=>$this->settings['company_zip'],
								'country'=>$this->settings['company_country'],
							),
							'permission_reminder'=>$this->settings['permission_reminder'],
							'campaign_defaults'=>array(
								'from_name'=>$this->settings['from_name'],
								'from_email'=>$this->settings['from_email'],
								'subject'=>$this->settings['subject'],
								'language'=>$this->settings['language']
								),
							'email_type_option'=>true
						);
						$id = $mc->create_list($list_args);
						$this->lists[$id] = $course->post_title;
						$list_ids[]=array('list_id'=>$id,'list_name'=>$course->post_title);
						update_post_meta($course->ID,'vibe_wplms_mailchimp_list',$id);
					}else{
						$id = array_search($course->post_title,$this->lists);
						$list_ids[]=array('list_id'=>$id,'list_name'=>$course->post_title);
					}
				}
			}	
		}
		print_r(json_encode($list_ids));
		die();
	}

	function course_lists_put(){
		if ( !isset($_POST['security']) || !wp_verify_nonce($_POST['security'],'wplms_mailchimp_settings') ){
		     echo '<div class="error notice is-dismissible"><p>'.__('Security check Failed. Contact Administrator.','wplms-mc').'</p></div>';
		}
		
		$mc = new Wplms_Mailchimp($this->settings['mailchimp_api_key']);
	
		$data = json_decode(stripslashes($_POST['data']));
		
		if(!empty($data)){
			$list_ids = array();
			foreach($data as $d){
				$all_lists[$d->list_id] = $d->list_name;
			}
			$this->course_specific_lists($all_lists,$_POST['status_group'],$_POST['expiry_group']);
		}

		die();	
	}

	function course_specific_lists($list_ids,$status_group = NULL,$expiry_group = NULL){

		$all_user_mails = $all_lists = $merge_all_fields = $member_all_interests = $status_interest_cat_ids = $expiry_interest_cat_ids = array();
		
		$literals = $this->get_literals();
		$mc = new Wplms_Mailchimp($this->settings['mailchimp_api_key']);
		if(!empty($list_ids)){
			
			foreach($list_ids as $list_id => $list_name){
				if(!empty($list_id)){
					$all_lists[$list_id] = $list_name;
					
					$all_user_mails[$list_id] = array();
					
					$all_list_emails = $mc->get_all_emails_from_list($list_id);
					if(!empty($all_list_emails)){
						foreach($all_list_emails as $email){
							
							$merge_all_fields[$list_id][$email['email']] = (array)$email['info']['merge_fields'];
							$member_all_interests[$list_id][$email['email']] = (array)$email['info']['interests'];							
						}
					}

					$interest_cat_ids[$list_id] = $mc->get_list_interest_categories($list_id);
						
					if(!empty($status_group)){ 
						$status_group_id = '';
						if(!empty($interest_cat_ids) && !empty($interest_cat_ids[$list_id])){
							$status_group_id = array_search($status_group,$interest_cat_ids[$list_id]);
						}

						if(empty($status_group_id) && !in_array($status_group,$interest_cat_ids[$list_id])){
							$status_group_id = $mc->create_interest_categories($list_id,array('title'=>$status_group,'type'=>'radio'));
						}

						$status_interest_cat_ids[$list_id] = array($status_group_id=>array());

						$my_course_statuses = array('pursuing','finished');
						//GET EXISTING INTERESTS
						$interest_ids = $mc->get_interest_category_interest_ids($list_id,$status_group_id);
						

						foreach($my_course_statuses as $status){
							if(in_Array($literals[$status],$interest_ids)){
								$id = array_search($literals[$status],$interest_ids);
							}else{
								$id = $mc->create_interest_category_interest($list_id,$status_group_id,$literals[$status]);
							}
							$status_interest_cat_ids[$list_id][$status_group_id][$id]=$literals[$status];
						}
					}

					if(!empty($expiry_group)){
						$expiry_group_id = '';
						if(!empty($interest_cat_ids) && !empty($interest_cat_ids[$list_id])){
							$expiry_group_id = array_search($expiry_group,$interest_cat_ids[$list_id]);
						}
							
						if(empty($expiry_group_id) && !in_Array($expiry_group,$interest_cat_ids[$list_id])){
							$expiry_group_id = $mc->create_interest_categories($list_id,array('title'=>$expiry_group,'type'=>'radio'));
						}

						$expiry_interest_cat_ids[$list_id] = array($expiry_group_id=>array());

						$expiry_statuses = array('active','expired');

						//GET EXISTING INTERESTS
						$interest_ids = $mc->get_interest_category_interest_ids($list_id,$expiry_group_id);

						foreach($expiry_statuses as $status){
							if(in_Array($literals[$status],$interest_ids)){
								$id = array_search($literals[$status],$interest_ids);
							}else{
								$id = $mc->create_interest_category_interest($list_id,$expiry_group_id,$literals[$status]);
							}
							$expiry_interest_cat_ids[$list_id][$expiry_group_id][$id]=$literals[$status];
						}
					}
					
				}
			}
		}
		
		print_r(' EXISTING INTERESTS ');
		print_r($member_all_interests);
		$time = time();
		global $wpdb;
		$all_users = $wpdb->get_results("SELECT u.user_email as email,
			u.display_name as name,
			p.post_title as course_name,
			IF(m.meta_value >= $time, 0, 1) as expired,
			m2.meta_value as course_status
			FROM {$wpdb->users} as u 
			LEFT JOIN {$wpdb->usermeta} as m 
			ON u.ID = m.user_id 
			LEFT JOIN {$wpdb->usermeta} as m2 
			ON u.ID = m2.user_id 
			LEFT JOIN {$wpdb->posts} as p 
			ON m.meta_key = p.ID 
			WHERE u.user_status = 0 
			AND m2.meta_key LIKE '%course_status%'
			AND p.post_type = 'course'
			AND p.post_status = 'publish'
			GROUP BY email, course_name");
		
		$merge_fields = $member_interests = array();
		
		if(!empty($all_users)){
			foreach($all_users as $user){

				if(in_array($user->course_name,$all_lists)){

					$list_id = array_search($user->course_name,$all_lists);
					
					$all_user_mails[$list_id][] = $user->email;

					if(empty($merge_all_fields[$user->email])){
						$mfields = explode(' ',$user->name);
						$fname = $mfields[0];
						$lname = '';
						if(!empty($mfields[1])){
							$lname = $mfields[1];
						}
						$merge_all_fields[$list_id][$user->email] = array('FNAME'=>$fname,'LNAME'=>$lname);
					}
					$key='';
					if(!empty($status_interest_cat_ids)){
						
						switch($user->course_status){
							case 1:
							case 2:
								$course_status = 'pursuing';
							break;
							case 3:
							case 4:
								$course_status = 'finished';
							break;
						}
						foreach($status_interest_cat_ids[$list_id] as $status_group_id => $status_interests){
							$key = array_search($literals[$course_status],$status_interests);
							break;
						}
						if(!empty($key)){
							if(empty($member_all_interests[$list_id][$user->email])){
								$member_all_interests[$list_id][$user->email] = array($key=> true);
							}else{
								$member_all_interests[$list_id][$user->email][$key]=true; 
							}	
						}
					}
					$key='';
					if(!empty($expiry_interest_cat_ids)){
						switch($user->expired){
							case 1:
								$course_status = 'expired';
							break;
							case 0:
								$course_status = 'active';
							break;
						}
						foreach($expiry_interest_cat_ids[$list_id] as $expiry_group_id => $expiry_interests){
							$key = array_search($literals[$course_status],$expiry_interests);
							break;
						}
						if(!empty($key)){
							if(empty($member_all_interests[$list_id][$user->email])){
								$member_all_interests[$list_id][$user->email] = array($key=> true);
							}else{
								$member_all_interests[$list_id][$user->email][$key]=true; 
							}
						}
					}
				}
			}// End for loop

			$tobe_added_mails = $tobe_rejected_mails = array();
			if(!empty($member_all_interests)){
				foreach($member_all_interests as $list_id=>$list_member_mails){
					$tobe_added_mails[$list_id] =  array_keys($list_member_mails); // Update status if required
				}
			}

			if(!empty($tobe_added_mails) || !empty($tobe_rejected_mails)){
				$mc->bulk_add_remove_emails_across_lists($tobe_added_mails,array(),$merge_all_fields,$member_all_interests);	
			}
		}
		return;
	}

	function wplms_mc_subscribe_to_list(){
		if ( !isset($_POST['security']) || !wp_verify_nonce($_POST['security'],$_POST['list']) ){
		    echo __('Security check Failed. Contact Administrator.','wplms-mc');
		    die();
		}

		if(empty($this->settings['mailchimp_api_key'])){
			echo __('Mailchimp Key is missing in settings.','wplms-mc');
			die();
		}

		$dummy = new wplms_mailchimp_subscribe_widget();
 		if( isset($dummy->captcha_enabled) && $dummy->captcha_enabled == 1 ){
			if(empty($this->settings['recaptcha_secret'])){
				echo __('Missing Captcha field','wplms-mc');
				die();
	 		}else{
	 			include_once 'recaptchalib.php';
	 			$objRecaptcha = new ReCaptcha( $this->settings['recaptcha_secret']);
				$response = $objRecaptcha->verifyResponse($_SERVER['REMOTE_ADDR'], $_POST['captcha']);
				if(!isset($response->success) || 1 != $response->success){
					echo __('Invalid Captcha field','wplms-mc');
					die();
				}
	 		}
 		}
	
		$mc = new Wplms_Mailchimp($this->settings['mailchimp_api_key']);
		$args = apply_filters('wplms_mailchimp_list_filters',array('email_address'=>$_POST['email']));
		$response = $mc->mailchimp_list_function($args,$_POST['list']);
		if(empty($response)){
			echo 1;
		}else{
			echo $response;
		}
		die();
	}

	function wplms_course_lists($fields){
		$lists = $this->get_lists();
		$options = array(
                array('label'=>__('None','wplms-mc'),'value'=>''),
                array('label'=>__('Disable','wplms-mc'),'value'=>'disable'),
	        );
		if(!empty($lists)){
			foreach($lists as $key=>$list){
				$options[]=array('label'=>$list,'value'=>$key);
			}	
		}
		
		$fields['vibe_wplms_mailchimp_list']=array(
			'label'	=> __('Select a Mailchimp List','wplms-mc'), // <label>
			'desc'	=> __('Select a post template for showing content.','wplms-mc'), // description
			'id'	=> 'vibe_wplms_mailchimp_list', // field id and name
			'type'	=> 'select', // type of field
	        'options' => $options
		);
		return $fields;
	}

	function add_to_list($course_id,$user_id){
		if(empty($this->settings['mailchimp_api_key']))
			return;

		$list_id = get_post_meta($course_id,'vibe_wplms_mailchimp_list',true);
		if(empty($list_id))
			return;

		$mc = new Wplms_Mailchimp($this->settings['mailchimp_api_key']);
		$user = get_user_by('ID',$user_id);


		$literals = $this->get_literals();
		$args = array('email_address'=>$user->user_email,'merge_fields'=>array('FNAME'=>$user->first_name,'LNAME'=>$user->last_name));

		if(!empty($this->settings['course_status_group'])){
			$interest_cat_ids = $mc->get_list_interest_categories($list_id);
			if(!empty($interest_cat_ids)){
				if(!empty($this->settings['course_status_group'])){
					$course_group_id = array_search($this->settings['course_status_group'],$interest_cat_ids);
					$interest_ids = $mc->get_interest_category_interest_ids($list_id,$course_group_id);
					$pursuing_id = array_search($literals['pursuing'],$interest_ids);
					$args['interests'][$pursuing_id] =true;
				}
				if(!empty($this->settings['course_expiry_group'])){
					$expiry_group_id = array_search($this->settings['course_expiry_group'],$interest_cat_ids);
					$interest_ids = $mc->get_interest_category_interest_ids($list_id,$expiry_group_id);
					$pursuing_id = array_search($literals['active'],$interest_ids);
					$args['interests'][$pursuing_id] =true;
				}
			}
		}

		$args = apply_filters('wplms_mailchimp_list_filters',$args,$user);
		$return = $mc->mailchimp_list_function($args,$list_id,'subscribed');
		return;		
	}

	function remove_from_list($course_id,$user_id){
		if(empty($this->settings['mailchimp_api_key']))
			return;

		$list_id = get_post_meta($course_id,'vibe_wplms_mailchimp_list',true);
		if(empty($list_id))
			return;

		$mc = new Wplms_Mailchimp($this->settings['mailchimp_api_key']);
		$user = get_user_by('ID',$user_id);
		$args = apply_filters('wplms_mailchimp_list_filters',array('email_address'=>$user->user_email),$user);
		$return = $mc->mailchimp_list_function($args,$list_id,'unsubscribed');
	}

	function change_status($course_id,$marks,$user_id){
		if(empty($this->settings['mailchimp_api_key']))
			return;

		$list_id = get_post_meta($course_id,'vibe_wplms_mailchimp_list',true);
		if(empty($list_id))
			return;
		
		$mc = new Wplms_Mailchimp($this->settings['mailchimp_api_key']);
		$user = get_user_by('ID',$user_id);


		$args = array('email_address'=>$user->user_email,'merge_fields'=>array('FNAME'=>$user->first_name,'LNAME'=>$user->last_name));

		if(!empty($this->settings['course_status_group'])){
			$interest_cat_ids = $mc->get_list_interest_categories($list_id);
			if(!empty($interests)){
				$course_group_id = array_search($this->settings['course_status_group'],$interest_cat_ids);
				$interest_ids = $mc->get_interest_category_interest_ids($list_id,$course_group_id);
				$pursuing_id = array_search('finished',$interest_ids);
				$args['interests'] = array($pursuing_id=>true);
			}
		}

		$args = apply_filters('wplms_mailchimp_list_filters',$args,$user);
		$return = $mc->mailchimp_list_function($args,$list_id,'subscribed','PATCH');
	}

	function sync_lists(){
		
		if(empty($this->lists))
			$this->get_lists();

		$list_types = array(
			'enable_registration',
			'enable_woo_subscription',
			'all_course_students',
			'all_instructors_list'
		);
		
		$mc = new Wplms_Mailchimp($this->settings['mailchimp_api_key']);
		foreach($list_types as $setting){
			if(!empty($this->settings[$setting])){ 
				$emails = $mc->get_all_emails_from_list($this->settings[$setting]);
				$all_emails = array();
				if(!empty($emails)){
					foreach($emails as $email){
						$all_emails[]=$email['email'];
					}	
				}
				$this->sync_lists_put_check($all_emails,$setting,$this->settings[$setting],$this->settings['course_group']);
			}
		}
		/*
		Sync Course specific lists
		 */
		global $wpdb;
		$course_lists = $wpdb->get_results("SELECT meta_value,post_id FROM {$wpdb->postmeta} WHERE meta_key = 'vibe_wplms_mailchimp_list'");


		$course_list_ids = $exclude_courses = array();
		$es_list_ids = array_keys($this->lists);
		
		if(!empty($course_lists)){
			foreach($course_lists as $list){
				if($list->meta_value == 'disable'){
					$exclude_courses[] = $list->post_id;
				}else{
					if(in_array($list->meta_value,$es_list_ids)){ // Check if list exists
						$course_list_ids[$list->meta_value] = get_the_title($list->post_id);	
					}
				}
			}
		}

		$extra_q = '';
		if(!empty($exclude_courses)){ 
			$extra_q = ' AND ID NOT IN ('.implode(',',$exclude_courses).')';
		}
		$courses = $wpdb->get_results("SELECT ID,post_title FROM {$wpdb->posts} WHERE post_status = 'publish' AND post_type ='course'$extra_q");

		
		$list_ids = array();
		if(!empty($courses)){
			foreach($courses as $course){
				if(!in_array($course->ID,$course_list_ids)){ // Does not have connected list
					if(!in_array($course->post_title,$this->lists)){
						$list_args = array(
							'name'=>$course->post_title,
							'contact'=>array(
								'company'=>$this->settings['company'],
								'address1'=>$this->settings['company_address'],
								'city'=>$this->settings['company_city'],
								'state'=>$this->settings['company_state'],
								'zip'=>$this->settings['company_zip'],
								'country'=>$this->settings['company_country'],
							),
							'permission_reminder'=>$this->settings['permission_reminder'],
							'campaign_defaults'=>array(
								'from_name'=>$this->settings['from_name'],
								'from_email'=>$this->settings['from_email'],
								'subject'=>$this->settings['subject'],
								'language'=>$this->settings['language']
								),
							'email_type_option'=>true
						);
						$id = $mc->create_list($list_args);
						$this->lists[$id] = $course->post_title;
						$course_list_ids[$id] = $course->post_title;	
						update_post_meta($course->ID,'vibe_wplms_mailchimp_list',$id);
					}
				}
			}	
		}
		
		if(!empty($course_list_ids)){
			$this->course_specific_lists($course_list_ids,$this->settings['course_status_group'],$this->settings['course_expiry_group']);
		}
        return;
	}

	function wplms_add_mailchimp_list_in_custom_registration_form( $settings ){

		if( $_POST['name'] ){
			$settings['mailchimp_list'] = '';
			return $settings;
		}

		$lists = $this->get_lists();
		if( empty($lists) )
			return $settings;

		$settings['mailchimp_list'] = array(
										'label' => __('Assign Mailchimp List','wplms-mc'),
										'default_option' => __('None','wplms-mc'),
										'options' => $lists
									);
		return $settings;
	}

	function wplms_add_mailchimp_checkbox_on_registration($name){
		$forms = get_option( 'wplms_registration_forms' );
		if( !empty( $forms[$name] ) ){
			$settings = $forms[$name]['settings'];

			if( isset($settings['mailchimp_list']) && !empty($settings['mailchimp_list']) ){
				echo '<div class="mailchimp_subscribe_checkbox" style="margin:15px 0;"><div class="checkbox">
			        <input type="checkbox" name="subscribe_mailchimp_list" id="subscribe_mailchimp_list" value="'.$settings['mailchimp_list'].'" checked /> <label for="subscribe_mailchimp_list">'._x('Subscribe to our newsletter','Mailchimp subscribe checkbox in custom registration form','wplms-mc').'</label>  
			        </div></div>';
			}
		}
	}

	function wplms_add_user_to_mailchimp_list_on_registration( $user_id,$user_args,$settings ){
		if( empty($settings) )
			return;

		foreach ($settings as $setting) {
			if( $setting->id == 'subscribe_mailchimp_list' ){
				$mc = new Wplms_Mailchimp($this->settings['mailchimp_api_key']);
				$user = get_user_by('ID',$user_id);
				$args = apply_filters('wplms_mailchimp_list_filters',array('email_address'=>$user_args['user_email']),$user);
				$mc->mailchimp_list_function($args,$setting->value);
			}
		}
	}
}

Wplms_Mailchimp_Init::init();