<?php
/**
 * MailChimp Class
 *
 * @author 		VibeThemes
 * @category 	Admin
 * @package 	Wplms-Mailchimp/Includes
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/* = DEVS If you're copying then please give Credits @Vibethemes @Ripul = */

class Wplms_Mailchimp{

	
	/*
	Mailchimp key
	 */
	private $apikey = '';

	/**
	* Constructor - if you're not using the class statically
	*
	* @param string $accessKey Access key
	* @param string $secretKey Secret key
	* @param boolean $useSSL Enable SSL
	* @param string $endpoint Amazon URI
	* @return void
	*/
	public function __construct($api_key = null)
	{
		$this->apikey = $api_key;
		$this->apiurl = 'https://' .substr($api_key,strpos($api_key,'-')+1).'.api.mailchimp.com/3.0/';
		$this->interest_ids = array();
		$this->args = array(
		 	'headers' => array(
				'Authorization' => 'Basic ' . base64_encode( 'user:'. $api_key )
			)
		);
	}


	function get_lists(){
		$response = wp_remote_get( $this->apiurl.'lists/?count=9999', $this->args );
		$body = json_decode( wp_remote_retrieve_body( $response ) );
		return $body;
	}

	function mailchimp_list_function($user_args,$list_id,$status = NULL,$method='PUT'){
		
		if(empty($status))
			$status = 'subscribed'; // subscribed, cleaned, pending, unsubscribed
		
		//ob_start();
		$args = $this->args; 
		$args['method'] = $method;
		
		$user_args['status']=$status;

		$args['body'] = json_encode($user_args);

		//print_r($args);
		$response = wp_remote_post(  $this->apiurl . 'lists/' . $list_id . '/members/' . md5(strtolower($email)), $args );	

		$body = json_decode( $response['body'] );
		if ( $response['response']['code'] == 200 && $body->status == $status ) {
			return 0;
		} else {
			return $response['response']['code'] . $body->title .' : '. $body->detail;
		}
	}

	function get_all_emails_from_list($list_id){

		$response = wp_remote_get( $this->apiurl.'lists/'.$list_id.'/members/', $this->args );
		$body = json_decode( wp_remote_retrieve_body( $response ) );
		$emails = array();
		 
		if ( wp_remote_retrieve_response_code( $response ) == 200 ) {
			foreach ( $body->members as $member ) {
				if( $member->status != 'subscribed' )
					continue;
				$emails[] = array('email'=>$member->email_address,'info'=>array('merge_fields'=>$member->merge_fields,'interests'=>$member->interests));
			}
			return $emails;
		}else {
			echo '<b>' . wp_remote_retrieve_response_code( $response ) . wp_remote_retrieve_response_message( $response ) . ':</b> ' . $body->detail;
		}
	}


	function bulk_add_remove_emails($list_id,$add_emails = NULL,$remove_emails = NULL,$merge_fields = NULL, $interests = NULL){
		
		$args = $this->args;
		$body_args = new stdClass();
		$body_args->operations = array();
		
		if(!empty($add_emails)){
			foreach($add_emails as $email){
				$batch =  new stdClass();
				$batch->method = 'PUT';
				$batch->path = 'lists/' . $list_id . '/members/' . md5(strtolower($email));
				$batchargs = array(
					'email_address' => $email,
					'status_if_new'        => 'subscribed',
				);
				if(!empty($merge_fields)){
					if(!empty($merge_fields[$email])){
						$batchargs['merge_fields'] = $merge_fields[$email];
					}
				}
				if(!empty($interests)){
					if(!empty($interests[$email])){
						$batchargs['interests'] = $interests[$email];
					}
				}
				$batch->body = json_encode($batchargs);
				$body_args->operations[] = $batch;
			}
		}
		if(!empty($remove_emails)){
			foreach($remove_emails as $email){
				$batch =  new stdClass();
				$batch->method = 'DELETE';
				$batch->path = 'lists/' . $list_id . '/members/' . md5(strtolower($email));
				$batch->body = json_encode( array(
					'email_address' => $email,
				) );
				$body_args->operations[] = $batch;
			}
		}
		$args['method'] =  'POST';
		$args['body'] = json_encode( $body_args );
		$response = wp_remote_post( $this->apiurl.'batches', $args );
		$body = json_decode( wp_remote_retrieve_body( $response ) );
		print_r($body);
		return;
	}

	function bulk_add_remove_emails_across_lists($add_emails = NULL,$remove_emails = NULL,$merge_fields = NULL, $interests = NULL){
		$args = $this->args;
		$body_args = new stdClass();
		$body_args->operations = array();
		
		if(!empty($add_emails)){
			foreach($add_emails as $list_id => $emails){
				foreach($emails as $email){
					$batch =  new stdClass();
					$batch->method = 'PUT';
					$batch->path = 'lists/' . $list_id . '/members/' . md5(strtolower($email));
					$batchargs = array(
						'email_address' => $email,
						'status_if_new'  => 'subscribed',
					);
					if(!empty($merge_fields)){
						if(!empty($merge_fields[$list_id][$email])){
							$batchargs['merge_fields'] = $merge_fields[$list_id][$email];
						}
					}
					if(!empty($interests)){
						if(!empty($interests[$list_id][$email])){
							$batchargs['interests'] = $interests[$list_id][$email];
						}
					}
					$batch->body = json_encode($batchargs);
					$body_args->operations[] = $batch;
				}
			}
		}
		if(!empty($remove_emails)){
			foreach($remove_emails as $list_id=>$email){
				$batch =  new stdClass();
				$batch->method = 'DELETE';
				$batch->path = 'lists/' . $list_id . '/members/' . md5(strtolower($email));
				$batch->body = json_encode( array(
					'email_address' => $email,
				) );
				$body_args->operations[] = $batch;
			}
		}
		$args['method'] =  'POST';
		$args['body'] = json_encode( $body_args );
		$response = wp_remote_post( $this->apiurl.'batches', $args );
		$body = json_decode( wp_remote_retrieve_body( $response ) );
		
		print_r($body);
		return;
	}

	function get_batch_status($batch_id){
		$response = wp_remote_get( $this->apiurl.'batches/'.$batch_id, $this->args );
		$body = json_decode( wp_remote_retrieve_body( $response ) );
		return $body;
	}

	function get_list_interest_categories($list_id){
		$response = wp_remote_get( $this->apiurl.'lists/'.$list_id.'/interest-categories', $this->args );
		$body = json_decode( wp_remote_retrieve_body( $response ) );
		
		$all_categories = array();	
		if(!empty($body) && !empty($body->categories)){
			foreach($body->categories as $category){
				$all_categories[$category->id] = $category->title;
			}
		}
		return $all_categories;
	}

	function create_interest_category_id($list_id,$name){
		$response = wp_remote_post( $this->apiurl.'lists/'.$list_id.'/interest-categories', $args );
		$response = json_decode(wp_remote_retrieve_body($response));
		return $response->id;
	}

	function create_interest_categories($list_id,$user_args){
		$args = $this->args;
		$args['method'] = 'POST';
		$args['body'] = json_encode($user_args); 			
		$response = wp_remote_post( $this->apiurl.'lists/'.$list_id.'/interest-categories', $args );
		$response = json_decode(wp_remote_retrieve_body($response));
		return $response->id;
	}

	function get_interest_category_interest_ids($list_id,$interest_id){

		$response = wp_remote_get( $this->apiurl.'lists/'.$list_id.'/interest-categories/'.$interest_id.'/interests', $this->args );
		$body = json_decode( wp_remote_retrieve_body( $response ) );
		$interests = array();

		if(!empty($body) && is_object($body) && isset($body->interests)){
			foreach($body->interests as $i){
					$interests[$i->id]=$i->name;
			}	
		}
		return $interests;
	}

	function create_interest_category_interest($list_id,$interest_id,$title){
		$args = $this->args; 
		$args['method'] = 'POST';
		$user_args['name']=$title;
		$args['body'] = json_encode($user_args);
		
		$response = wp_remote_post(  $this->apiurl.'lists/'.$list_id.'/interest-categories/'.$interest_id.'/interests', $args );
		$body = json_decode( wp_remote_retrieve_body( $response ) );
		
		if(!empty($body))
			return $body->id;
	}
	
	function create_list($list_args){
		$args = $this->args;
		$args['method'] = 'POST';
		$args['body'] = json_encode($list_args);
		$response = wp_remote_post(  $this->apiurl.'lists', $args );
		$body = json_decode( wp_remote_retrieve_body( $response ) );
		if(!empty($body))
			return $body->id;
	}

	function debug($streamopt){
		$myFile = "mailchimp_debug.txt";
        if (file_exists($myFile)) {
          $fh = fopen($myFile, 'a');
          fwrite($fh, print_r($streamopt, true)."\n");
        } else {
          $fh = fopen($myFile, 'w');
          fwrite($fh, print_r($streamopt, true)."\n");
        }
        fwrite($fh, print_r(json_encode($data, JSON_PRETTY_PRINT), true)."\n");
        fclose($fh);  
	}
}

