<?php
/*
Plugin Name: WPLMS MailChimp
Plugin URI: http://www.vibethemes.com/
Description: This plugin integrates WPLMS with MailChimp
Version: 1.5.2
Author: Mr.Vibe
Author URI: http://www.vibethemes.com/
Text Domain: wplms-mc
Domain Path: /languages/
*/
if ( !defined( 'ABSPATH' ) ) exit; 
/*  Copyright 2016 VibeThemes  (email: vibethemes@gmail.com) */


include_once 'includes/class.updater.php';
include_once 'includes/class.config.php';
include_once 'includes/class.mailchimp.php';
include_once 'includes/class.init.php';
include_once 'includes/class.admin.php';
include_once 'includes/class.widgets.php';

add_action('plugins_loaded','wplms_mailchimp_translations');
function wplms_mailchimp_translations(){
    $locale = apply_filters("plugin_locale", get_locale(), 'wplms-mc');
    $lang_dir = dirname( __FILE__ ) . '/languages/';
    $mofile        = sprintf( '%1$s-%2$s.mo', 'wplms-mc', $locale );
    $mofile_local  = $lang_dir . $mofile;
    $mofile_global = WP_LANG_DIR . '/plugins/' . $mofile;

    if ( file_exists( $mofile_global ) ) {
        load_textdomain( 'wplms-mc', $mofile_global );
    } else {
        load_textdomain( 'wplms-mc', $mofile_local );
    }  
}


function Wplms_Mailchimp_Plugin_updater() {
    $license_key = trim( get_option( 'wplms_mailchimp_license_key' ) );
    $edd_updater = new Wplms_MailChimp_Plugin_Updater( 'http://wplms.io', __FILE__, array(
            'version'   => '1.5.2',               
            'license'   => $license_key,        
            'item_name' => 'WPLMS MailChimp',    
            'author'    => 'VibeThemes' 
        )
    );
}
add_action( 'admin_init', 'Wplms_Mailchimp_Plugin_updater', 0 );
