<?php
/**
 * Initialise WPLMS Certificates
 *
 * @author 		VibeThemes
 * @category 	Admin
 * @package 	Wplms-Wishlist/Includes
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class Wplms_Pdf_Certificates_Init{

	public static $instance;
    
    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new Wplms_Pdf_Certificates_Init();
        return self::$instance;
    }

	private function __construct(){

		add_action('wplms_certificate_earned',array($this,'certificate_earned'),10,3);
		add_action('wplms_bulk_action',array($this,'bulk_action'),1,3);

		add_filter('wplms_certificate_metabox',array($this,'pdf_certificate'));
		add_filter('custom_meta_box_type',array($this,'pdf_type'),10,5);
		add_filter('wplms_certificates_pdf_args',array($this,'certificate_margins'));
		add_filter('wplms_pdf_certificate_orientation',array($this,'pdf_orientation'));
		add_filter('wplms_pdf_certificate_unit',array($this,'pdf_unit'));
		add_filter('wplms_pdf_certificate_format',array($this,'pdf_format'));
		add_action('wp_ajax_generate_pdf_certificate',array($this,'generate_pdf_certificate'));

		add_action('wp_head',array($this,'certificate_corrections'),99);

		add_action('bp_before_profile_content',array($this,'get_pdf_certificates'));
		
	}

	function get_pdf_certificates($user_id = null){

		if(empty($user_id)){
			$user_id = bp_displayed_user_id();	
		}
		
		global $wpdb;
		$name = sanitize_title(bp_core_get_user_displayname($user_id)).'_%';
		$certificates = $wpdb->get_results("SELECT ID,post_parent FROM {$wpdb->posts} WHERE post_type ='attachment' AND post_mime_type = 'application/pdf' AND post_name LIKE '".$name."'");
		
		if(!empty($certificates)){
			$wplms_pdf_certificates = array();
			foreach($certificates as $certificate){
				$wplms_pdf_certificates[$certificate->post_parent]=wp_get_attachment_url($certificate->ID);
			}
			?>
			<script>
				var wplms_pdf_certificates = <?php echo json_encode($wplms_pdf_certificates); ?>
			</script>
			<?php
		}
		?>
		<style>#certificate img.mfp-img {padding: 0;}</style>
		<?php
	}
	function certificate_corrections(){
		if(is_singular('certificate')){
			$width = get_post_meta(get_the_ID(),'vibe_certificate_width',true);
			$height = get_post_meta(get_the_ID(),'vibe_certificate_height',true);
			?>
			<style>.certificate_content{    
				background-size: 98% !important;
				background-repeat: no-repeat !important;
				width:<?php echo $width; ?>px;
				height:<?php echo $height; ?>px;
			}
			</style>
			<?php
		}
	}

	function certificate_margins($margins){

		if(!empty($this->template_id)){
			$setmargins = get_post_meta($this->template_id,'vibe_pdf_certificate_margins',true);
			if(!empty($setmargins)){
				if(is_numeric($setmargins)){
					$margins = array(
						'margin_left'=>$setmargins,
						'margin_top'=>$setmargins,
						'margin_right'=>$setmargins,
						'margin_bottom'=>$setmargins
					);
				}elseif(strpos($setmargins, ',')!== false){
					$mm = explode(',',$setmargins);
					if(is_array($mm)){
						$margins = array(
							'margin_top'=>$mm[0],
							'margin_right'=>$mm[1],
							'margin_bottom'=>$mm[2],
							'margin_left'=>$mm[3]
						);
					}
				}
			}
		}
		


		return $margins;
	}

	function pdf_orientation($orientation){

		if(!empty($this->template_id)){
			$vibe_pdf_orientation = get_post_meta($this->template_id,'vibe_pdf_orientation',true);
			if(!empty($vibe_pdf_orientation)){
				$o = explode(' ',$vibe_pdf_orientation);
				if($o[1] == 'LANDSCAPE'){
					$orientation = 'L';
					$this->orientation = $orientation;
				}
			}
		}

		return $orientation;
	}

	function pdf_unit($unit){
		if(!empty($this->template_id)){
			$vibe_pdf_orientation = get_post_meta($this->template_id,'vibe_pdf_orientation',true);
			if(!empty($vibe_pdf_orientation)){
				$o = explode(' ',$vibe_pdf_orientation);
				$unit = $o[0];
				$this->unit = $unit;
			}
		}
		return $unit;
	}

	function pdf_format($format){
		if(!empty($this->template_id)){
			$vibe_pdf_orientation = get_post_meta($this->template_id,'vibe_pdf_orientation',true);
			if(!empty($vibe_pdf_orientation)){
				$format = $vibe_pdf_orientation;
				$this->format = $format;
			}
		}
		return $format;
	}

	function pdf_certificate($metabox){
		$metabox[]=array( // Text Input
					'label'	=> __('PDF CERTIFICATES','wplms-pdf-certificates'), // <label>
					'desc'	=> __('Show sample certificate PDF','wplms-pdf-certificates'), // description
					'id'	=> 'vibe_certificate_pdf', // field id and name
					'type'	=> 'certificate_pdf', // type of field
				);
		$metabox[]=array( // Text Input
					'label'	=> __('PDF Margins','wplms-pdf-certificates'), // <label>
					'desc'	=> __('Add a single numerical margin on all sides -> 30 OR a comma saperated margin Top,Right,Bottom,Left -> 30,20,40,50. All margins are in milimeters','wplms-pdf-certificates'), // description
					'id'	=> 'vibe_pdf_certificate_margins', // field id and name
					'type'	=> 'text', // type of field
				);
		$metabox[]=array( // Text Input
					'label'	=> __('PDF Orientation','wplms-pdf-certificates'), // <label>
					'desc'	=> __('PDF Page orientation','wplms-pdf-certificatess'), // description
					'id'	=> 'vibe_pdf_orientation', // field id and name
					'options'=>array(
						array('label'=>__('Custom','wplms-pdf-certificates'),'value'=>''),
						array('label'=>__('A4 PORTRAIT','wplms-pdf-certificates'),'value'=>'A4 PORTRAIT'),
						array('label'=>__('A4 LANDSCAPE','wplms-pdf-certificates'),'value'=>'A4 LANDSCAPE'),
						array('label'=>__('A5 PORTRAIT','wplms-pdf-certificates'),'value'=>'A5 PORTRAIT'),
						array('label'=>__('A5 LANDSCAPE','wplms-pdf-certificates'),'value'=>'A5 LANDSCAPE'),
						array('label'=>__('A6 PORTRAIT','wplms-pdf-certificates'),'value'=>'A6 PORTRAIT'),
						array('label'=>__('A6 LANDSCAPE','wplms-pdf-certificates'),'value'=>'A6 LANDSCAPE'),
						array('label'=>__('A7 PORTRAIT','wplms-pdf-certificates'),'value'=>'A7 PORTRAIT'),
						array('label'=>__('A7 LANDSCAPE','wplms-pdf-certificates'),'value'=>'A7 LANDSCAPE'),
					),
					'type'	=> 'select', // type of field
				);
		
		return $metabox;
	}
	function pdf_type($type,$meta,$id,$desc,$post_type){

		if($post_type == 'certificate'){
			if($type == 'certificate_pdf'){
				


				global $wpdb;
				$attachment_id = $wpdb->get_var("SELECT ID FROM {$wpdb->posts} WHERE post_name = 'sample-".get_post_field('post_name',get_the_ID())."' and post_type = 'attachment' ORDER BY ID DESC limit 0,1");

				echo '<a href="'.get_permalink().'?pdf" target="_blank" class="button">'.__('View PDF HTML','wplms-pdf-certificates').'</a>&nbsp;';
				if(!empty($attachment_id)){
					echo '<a id="generate_sample_certificate" class="button-primary">'._x('Re-Generate PDF certificate',' wplms-pdf-certificates').'</a>';
					echo '&nbsp;<a href="'.wp_get_attachment_url($attachment_id).'" target="_blank" class="button" id="sample_certificate" class="button">'.__('Download PDF','wplms-pdf-certificates').'</a>';
				}else{
					echo '<a id="generate_sample_certificate" class="button-primary">'._x('Generate PDF certificate',' wplms-pdf-certificates').'</a>';
				}
				?>
				<script>
					jQuery(document).ready(function(){
					jQuery('#vibe_pdf_orientation').on('change',function(){
						
						var stored = 0;

						var params={width:0,height:0};

						if(!stored){
							stored = {width:jQuery('#vibe_certificate_width').val(),height:jQuery('#vibe_certificate_height').val()};
							params={width:stored.width,height:stored.height};
						}
						 
						switch(jQuery(this).val()){
							case 'A4 PORTRAIT':
								params={width:595,height:842};
							break;
							case 'A4 LANDSCAPE':
								params={width:842,height:595};
							break;
							case 'A5 PORTRAIT':
								params={width:630,height:892};
							break;
							case 'A5 LANDSCAPE':
								params={width:892,height:630};
							break;
							case 'A6 PORTRAIT':
								params={width:596,height:840};
							break;
							case 'A6 LANDSCAPE':
								params={width:840,height:596};
							break;
							case 'A7 PORTRAIT':
								params={width:630,height:894};
							break;
							case 'A7 LANDSCAPE':
								params={width:894,height:630};
							break;
							default:
								if(stored){
									params={width:stored.width,height:stored.height};
								}
							break;
						}

						jQuery('#vibe_certificate_width').val(params.width);
						jQuery('#vibe_certificate_height').val(params.height);
					});

					jQuery('#generate_sample_certificate').on('click',function(){
						var $this = $(this);
						var dtext = $this.text();
						$this.text('<?php _e('...generating','wplms-pdf-certificates') ?>');
						jQuery('#sample_certificate').remove();
						$.ajax({
				          	type: "POST",
				          	url: ajaxurl,
				          	data: { 
				          		action: 'generate_pdf_certificate',
			          			security: '<?php echo wp_create_nonce('security'); ?>',
			                  	template_id: <?php echo get_the_ID(); ?>,
			                },
				          	cache: false,
				          	success: function (html) {
				            	var regex = /(http|https):\/\/(\w+:{0,1}\w*)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%!\-\/]))?/;
  								if(regex .test(html)) {
  									jQuery('#generate_sample_certificate').after('<a href="'+html+'" id="sample_certificate" target="_blank" class="button">&nbsp;<?php _e('Download','wplms-pdf-certificates'); ?></a>');
  								}else{
  									alert(html);
  								}

  								$this.text(dtext);
				          	}
				        });
					});
				});
				</script>
				<?php
			}
		}

		return $type;
	}

	function generate_pdf_certificate(){

		if(!current_user_can('edit_posts') || !wp_verify_nonce($_POST['security'],'security') || !is_numeric($_POST['template_id'])){
			_e('Security check failed !','wplms-pdf-certificates');
			die();
		}

		$this->template_id = $_POST['template_id'];
  		$upload_dir = wp_upload_dir();
  		$name = 'sample_'.get_post_field('post_name',$_POST['template_id']).'.pdf';
		$full_path = $upload_dir['path'].'/'.$name;

		$this->certificate_json = get_post_meta($_POST['template_id'],'certificate_json',true);
		

		if(!empty($this->certificate_json)){

			$query = new WP_Query(array('p'=>$_POST['template_id']));
			if($query->have_posts()){
				while($query->have_posts()){
					$query->the_post();
					global $post;
					foreach($this->certificate_json as $key=>$value){
						if(!empty($value['value'])){
							$this->certificate_json[$key]['value']=apply_filters('the_content',$value['value']);
						}
					}
				}
			}

			$bg_image_id = get_post_meta($_POST['template_id'],'vibe_background_image',true);
			
			if(is_numeric($bg_image_id)){
				$this->bg_image = get_attached_file($bg_image_id);
			}

			$attachment_id = $this->generate_json_certificate($this->certificate_json,'Sample '.get_the_title($_POST['template_id']),$full_path);
	  		if(is_numeric($attachment_id)){
	  			echo wp_get_attachment_url($attachment_id);
	  		}else{
	  			_e('Attachmend failed','wplms-pdf-certificates');
	  		}
			die();
		}

		$url = get_permalink($_POST['template_id']).'?pdf';
		
		$this->template_id = $_POST['template_id'];

		$response = wp_remote_get($url,array('timeout'=>30));

		if ( is_array( $response ) &&  wp_remote_retrieve_response_code( $response ) == 200) {
	  		$body =  wp_remote_retrieve_body($response);

	  		//
	  		$body = preg_replace("/<script((?:(?!src=).)*?)>(.*?)<\/script>/smix", "", $body);
	  		
	  		$body = str_replace("<a class='evolbclose '>X</a>", "", $body);
	  		
	  		
	  		$bg_image_id = get_post_meta($this->template_id,'vibe_background_image',true);
			
			if(is_numeric($bg_image_id)){
				$this->bg_image = get_attached_file($bg_image_id);
			}
			$this->user_id = get_current_user_id();
			global $wpdb;
			$old_attachment_id = $wpdb->get_var("SELECT ID FROM {$wpdb->posts} WHERE post_name LIKE '%sample_".get_post_field('post_name',$this->template_id)."%' AND post_type = 'attachment' ORDER BY ID DESC limit 0,1");
			if(is_numeric($old_attachment_id)){
				wp_delete_attachment( $old_attachment_id, true );
			}

	  		$attachment_id = $this->generate_certificate($body,'Sample '.get_the_title($this->template_id),$full_path);

	  		if(is_numeric($attachment_id)){
	  			echo wp_get_attachment_url($attachment_id);
	  		}else{
	  			_e('Attachmend failed','wplms-pdf-certificates');
	  		}

		}else{
			_e('Failed to load Certificate','wplms-pdf-certificates');
		}

		die();

	}
	function bulk_action($action,$course_id,$members){

		if($action == 'add_certificate'){

			if(!empty($members)){
				foreach($members as $user_id){
					ob_start();
						$this->generate_certificate_pdf($course_id,'',$user_id);
					ob_end_clean();
				}
			}
		}
	}

	function certificate_earned($course_id,$pass,$user_id){
		ob_start();
			$this->generate_certificate_pdf($course_id,$pass,$user_id);
		ob_end_clean();
		$this->get_pdf_certificates($user_id);
		return;
	}

	function generate_certificate_pdf($course_id,$pass,$user_id){


		if(!function_exists('vibe_get_option')){
			return; 
		}
		$this->bg_image = 0;
		$template_id = get_post_meta($course_id,'vibe_certificate_template',true);
		if(empty($template_id)  || $template_id =='H' ){
			return;
		}else{
			$bg_image_id = get_post_meta($template_id,'vibe_background_image',true);
			
			if(is_numeric($bg_image_id)){
				$this->bg_image = get_attached_file($bg_image_id);
			}
			
		}
		

		
		
		$this->user_id = $user_id;
		$this->course_id = $course_id;
		$this->template_id = $template_id;

		$upload_dir = wp_upload_dir();
  		$name = $course_id.'_'.$user_id.'.pdf';
  		$display_name = bp_core_get_user_displayname($user_id).'_'.get_the_title($course_id); 
		$full_path = $upload_dir['path'].'/'.$name;

		$this->certificate_json = get_post_meta($this->template_id,'certificate_json',true);
		
		
		if(!empty($this->certificate_json)){
			
			$this->certificate_json = json_decode($this->certificate_json,true);
			$query = new WP_Query(array('p'=>$template_id,'post_type'=>'certificate'));
			$_GET['c']=$course_id;
			$_GET['u']=$user_id;
			
			if($query->have_posts()){
				while($query->have_posts()){
					$query->the_post();
					global $post;
					
					foreach($this->certificate_json as $key=>$value){
						if(!empty($value['value']) && $value['type'] == 'text' ){
							
							$this->certificate_json[$key]['value']=do_shortcode($value['value']);
						}
					}
				}
				wp_reset_postdata();
			}

			$attachment_id = $this->generate_json_certificate(json_encode($this->certificate_json),$display_name,$full_path);
	  		if(is_numeric($attachment_id)){
	  			echo wp_get_attachment_url($attachment_id);
	  		}else{
	  			_e('Attachmend failed','wplms-pdf-certificates');
	  		}
			return;
		}
		
		$url = get_permalink($template_id).'?u='.$user_id.'&c='.$course_id.'&pdf';

		$response = wp_remote_get($url,array('timeout'=>30));

		if ( is_array( $response ) &&  wp_remote_retrieve_response_code( $response ) == 200) {
	  		$body =  wp_remote_retrieve_body($response);

	  		//
	  		$body = preg_replace("/<script((?:(?!src=).)*?)>(.*?)<\/script>/smix", "", $body);
	  		
	  		$body = str_replace("<a class='evolbclose '>X</a>", "", $body);
	  		
	  		
	  		
	  		
	  		$attachment_id = $this->generate_certificate($body,$display_name,$full_path);
	  		if(is_numeric($attachment_id)){
	  			echo wp_get_attachment_url($attachment_id);
	  		}else{
	  			_e('Attachmend failed','wplms-pdf-certificates');
	  		}

		}else{
			_e('Failed to load Certificate','wplms-pdf-certificates');
		}

		return;
	}

	function generate_certificate($html,$name,$pdf_path){
		// Include the main TCPDF library (search for installation path).
		
		require_once( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'myPDF.php' );

		
		$orientation = apply_filters('wplms_pdf_certificate_orientation',PDF_PAGE_ORIENTATION);
		$pdf_unit = apply_filters('wplms_pdf_certificate_unit',PDF_UNIT);
		$pdf_page_format = apply_filters('wplms_pdf_certificate_format',PDF_PAGE_FORMAT);
		
		if(!empty($this->bg_image)){
			// create new PDF document
			$pdf = new MYPDF($orientation, PDF_UNIT, $pdf_page_format, true, 'UTF-8', false);
		}else{
			$pdf = new TCPDF($orientation, PDF_UNIT, $pdf_page_format, true, 'UTF-8', false);
		}
		// set document information
		$pdf->SetCreator(get_bloginfo('name'));
		$pdf->SetAuthor(get_bloginfo('name'));
		$pdf->SetTitle($name);
		$pdf->SetDisplayMode('fullpage', 'SinglePage', 'UseNone');
		//$pdf->SetFont('helvetica', '', 10);

		$pdf_args = apply_filters('wplms_certificates_pdf_args',array(
			'margin_left'=>30,
			'margin_top'=>30,
			'margin_right'=>30,
			'margin_bottom'=>30
		));

		// set margins
		$pdf->SetMargins($pdf_args['margin_left'],$pdf_args['margin_top'], $pdf_args['margin_right'],true);
		// add a page

		$pdf->AddPage($orientation, $pdf_unit);

		//QR CODE

		// $style = array(
		//     'border' => 2,
		//     'vpadding' => 'auto',
		//     'hpadding' => 'auto',
		//     'fgcolor' => array(0,0,0),
		//     'bgcolor' => false, //array(255,255,255)
		//     'module_width' => 1, // width of a single module in points
		//     'module_height' => 1 // height of a single module in points
		// );
		//$pdf->write2DBarcode('www.tcpdf.org', 'QRCODE,L', 20, 30, 50, 50, $style, 'N');
		//$pdf->Text(20, 25, 'QRCODE L');

		
		do_action('wplms_generating_certificate_pdf',$pdf,$this);

		$pdf->setCellHeightRatio(1);
      
        

		$pdf->writeHTML($html, true, false, true, false, '');

		global $wpdb;
		$old_attachment_id = $wpdb->get_var("SELECT ID FROM {$wpdb->posts} WHERE post_name LIKE '%sample_".get_post_field('post_name',$this->template_id)."%' AND post_type = 'attachment' ORDER BY ID DESC limit 0,1");

		if(is_numeric($old_attachment_id)){
			wp_delete_attachment( $old_attachment_id, true );
		}

		// add a page
		ob_start();
		$pdf->Output($pdf_path, 'FI');
		ob_end_clean();


		if(file_exists($pdf_path)){
			$filetype = wp_check_filetype( basename( $pdf_path ), null );

			$attachment = apply_filters('wplms_certificate_pdf_attachment',array(
				'guid'           => $wp_upload_dir['url'] . '/' . basename( $pdf_path ), 
				'post_mime_type' => $filetype['type'],
				'post_title'     => preg_replace( '/\.[^.]+$/', '', _x('Certificate for ','certificate title','wplms-certificates').'-'.$name ),
				'post_name'=>sanitize_title($name),
				'post_content'   => '',
				'post_author'=>$this->user_id,
				'post_status'    => 'inherit'
			));

			if(!empty($this->course_id)){
				$attachment_id = wp_insert_attachment($attachment,$pdf_path,$this->course_id);	
			}else{
				$attachment_id = wp_insert_attachment($attachment,$pdf_path);
			}
	  		
	  		return $attachment_id;
		}
	}


	function generate_json_certificate($array,$name,$pdf_path){

		
		require_once( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'myPDF.php' );

		
		$orientation = apply_filters('wplms_pdf_certificate_orientation',PDF_PAGE_ORIENTATION);
		$pdf_unit = apply_filters('wplms_pdf_certificate_unit',PDF_UNIT);
		$pdf_page_format = apply_filters('wplms_pdf_certificate_format',PDF_PAGE_FORMAT);
		
		if(!empty($this->bg_image)){
			// create new PDF document
			$pdf = new MYPDF($orientation, 'pt', $pdf_page_format, true, 'UTF-8', false);
		}else{
			$pdf = new TCPDF($orientation, 'pt', $pdf_page_format, true, 'UTF-8', false);
		}
		// set document information
		$pdf->SetCreator(get_bloginfo('name'));
		$pdf->SetAuthor(get_bloginfo('name'));
		$pdf->SetTitle($name);
		$pdf->SetDisplayMode('fullpage', 'SinglePage', 'UseNone');
		//$pdf->SetFont('helvetica', '', 10);

		$pdf_args = apply_filters('wplms_certificates_pdf_args',array(
			'margin_left'=>0,
			'margin_top'=>0,
			'margin_right'=>0,
			'margin_bottom'=>0
		));

		$pdf->setCellHeightRatio(1);
		// set margins
		$pdf->SetMargins($pdf_args['margin_left'],$pdf_args['margin_top'], $pdf_args['margin_right'],true);
		// add a page

		$pdf->AddPage($orientation, $pdf_unit);

		$array = json_decode($array,true);

		
		foreach($array as $eky=>$item){
			
			if($item['type'] == 'text'){
				
				if($item['color']){
					list($r, $g, $b) = sscanf($item['color'], "#%02x%02x%02x");
					$pdf->SetTextColor($r,$g,$b);
				}
				if($item['size']){
					if(!$item['family']){
						$item['family']='helvetica';
					}
					$pdf->SetFont ($item['family'], '', $item['size'] , '', 'default', true );	
				}
				

				if($string != strip_tags($string)) {
					$pdf->Text( $item['left'], $item['top'], $item['value'], false, false, true, 0, 0, '', false, '', 0, false, 'T', 'M', false );
				}else{
					$pdf->setXY($item['left'],$item['top'])	;
					$pdf->writeHTML($item['value'], true, false, true, false, '');	
				}
				
			}
			if($item['type'] == 'image'){
				if($item['radius']){
					$pdf->StartTransform();
					$pdf->Circle($item['left'], $item['top'], $item['width'], $item['height'], 3, 0, 1, 'CNZ');
				}
				if(strpos($item['value'], home_url()) !== false){
					$item['value'] = str_replace(home_url().'/wp-content', WP_CONTENT_DIR, $item['value']);
				}

				$pdf->Image($item['value'], $item['left'], $item['top'], $item['width'], $item['height'], '', '', '', true, 300);
				if($item['radius']){
					$pdf->StopTransform();
				}
			}
		}



		global $wpdb;
		$old_attachment_id = $wpdb->get_var("SELECT ID FROM {$wpdb->posts} WHERE post_name LIKE '%sample_".get_post_field('post_name',$this->template_id)."%' AND post_type = 'attachment' ORDER BY ID DESC limit 0,1");

		if(is_numeric($old_attachment_id)){
			wp_delete_attachment( $old_attachment_id, true );
		}
		// add a page

		ob_start();
		$pdf->Output($pdf_path, 'FI');
		ob_end_clean();
		global $wpdb;
		
		$this->user_id = get_current_user_id();
		if(file_exists($pdf_path)){
			$filetype = wp_check_filetype( basename( $pdf_path ), null );

			$attachment = apply_filters('wplms_certificate_pdf_attachment',array(
				'guid'           => $wp_upload_dir['url'] . '/' . basename( $pdf_path ), 
				'post_mime_type' => $filetype['type'],
				'post_title'     => preg_replace( '/\.[^.]+$/', '', _x('Certificate for ','certificate title','wplms-certificates').'-'.$name ),
				'post_name'=>sanitize_title($name),
				'post_content'   => '',
				'post_author'=>$this->user_id,
				'post_status'    => 'inherit'
			));

			
			

			if(!empty($this->course_id)){
				$attachment_id = wp_insert_attachment($attachment,$pdf_path,$this->course_id);	
			}else{
				$attachment_id = wp_insert_attachment($attachment,$pdf_path);
			}
	  		
	  		return $attachment_id;
		}
		
	}

}

Wplms_Pdf_Certificates_Init::init();