<?php
/*
Plugin Name: WPLMS Demo10 Sample Data
Plugin URI: http://www.vibethemes.com
Description: Install WPLMS Demo 10 in your site ( http://themes.vibethemes.com/wplms/skins/demo10 )
Author: VibeThemes
Version: 1.0
Author URI: http://www.vibethemes.com
Text Domain: wplms-demo10
*/

if ( ! defined( 'ABSPATH' ) ) exit;

class WPLMS_Demo10{

    public static $instance;
    
    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new WPLMS_Demo10();

        return self::$instance;
    }

    private function __construct(){
    	add_filter('wplms_required_plugins',array($this,'required_plugins'));
    	add_filter('wplms_setup_import_file_path',array($this,'import_file_path'),10,2);
    	add_filter('wplms_data_import_url',array($this,'import_url'));

    	add_filter('wplms_setup_options_panel',array($this,'options'));

    	add_action('init',array($this,'sidebars'));
    	add_action('wplms_after_sample_data_import',array($this,'wplms_customizer_options'),30);
    	add_action('wplms_after_sample_data_import',array($this,'add_custom_users'),99,1);
    	add_filter('wplms_setup_layerslider_file',array($this,'stop_layerslider'));
    	
		
    	add_action('wplms_after_sample_data_import',array($this,'import_layerslider'),99);

    	add_filter('wplms_setup_sidebars_file',array($this,'set_sidebars'));
    	add_filter('wplms_setup_widgets_file',array($this,'set_widgets'));
    	add_filter('wplms_setup_plugins',array($this,'setup_plugins'));
		
		//add_action('init',array($this,'wplms_demo1_sidebars_widgets'));
    }

    function sidebars(){
    	register_sidebar( array(
          	'name' => 'MegaMenu',
          	'id' => 'MegaMenu',
          	'before_widget' => '<div class="widget"><div class="inside">',
              'after_widget' => '</div></div>',
              'before_title' => '<h4 class="widgettitle"><span>',
              'after_title' => '</span></h4>',
            'description'   => __('This is the MegaMenu sidebar','vibe')
        ));
      	register_sidebar( array(
    	  	'name' => 'MegaMenu2',
          	'id' => 'MegaMenu2',
          	'before_widget' => '<div class="widget"><div class="inside">',
            'after_widget' => '</div></div>',
            'before_title' => '<h4 class="widgettitle"><span>',
            'after_title' => '</span></h4>',
          	'description'   => __('This is the MegaMenu2 sidebar','vibe')
      	));
    }

    function setup_plugins($flag){

    	if(is_plugin_active('revslider/revslider.php') && is_plugin_active('wplms-front-end/wplms-front-end.php') && is_plugin_active('woocommerce/woocommerce.php') && is_plugin_active('js_composer/js_composer.php')){ 
			return false;
		}
    	return $flag;
    }

    function required_plugins($plugins){
    	unset($plugins[6]);
    	return $plugins;
    }

    function stop_layerslider($file){
    	return '';
    }

    function set_sidebars($file){
    	return plugin_dir_path(__FILE__)."data/sidebars.txt";
    }

    function set_widgets($file){
    	return plugin_dir_path(__FILE__)."data/widgets.txt";
    }

    function import_layerslider(){

		$ls_slider_array = array(
			plugin_dir_path(__FILE__)."data/demo10-1.zip",
			plugin_dir_path(__FILE__)."data/demo10-2.zip",
			plugin_dir_path(__FILE__)."data/demo10-3.zip",
			);
		if(!empty($ls_slider_array)){
            include LS_ROOT_PATH.'/classes/class.ls.importutil.php';
            if(class_exists('LS_ImportUtil')){
                foreach($ls_slider_array as $url) {
                    $import = new LS_ImportUtil($url);
                }
            }
        }
		
    }

	function import_file_path($file_path,$file){
	    $file_path = plugin_dir_path(__FILE__).'data/demo10.xml';
	    return $file_path;
	}

	function import_url(){
	    return plugin_dir_url(__FILE__).'data/uploads/';
	}

	// Options panel
	function options($panel){
		//Extra options for options panel
		$panel['logo'] = plugin_dir_url( __FILE__ ).'data/uploads/logo.png';
		$panel['alt_logo'] = plugin_dir_url( __FILE__ ).'data/uploads/logo.png';
		$panel['footer_logo'] = plugin_dir_url( __FILE__ ).'data/uploads/logo.png';
		$panel['footerbottom_right']=1;
		$panel['social_icons'] = array('social'=>array('facebook','twitter','dribbble'),'url'=>array('#','#','#'));
		$panel['google_fonts'] = array('Lato-900-latin','Montserrat-regular-latin','Montserrat-700-latin','Open Sans-300-latin','Raleway-regular-latin','Raleway-800-latin');
		return $panel;
	}

	// Setup  Customizer 
	function wplms_customizer_options(){ 
	    $customizer_file = plugin_dir_path(__FILE__).'data/customiser.txt';
	    if(file_exists($customizer_file)){
	        $myfile = fopen($customizer_file , "r") or die("Unable to open file!".$customizer_file );
	        while(!feof($myfile)) {
	            $string = fgets($myfile);
	        }
	        fclose($myfile);
	        $code = base64_decode(trim($string)); 
	        if(is_string($code)){
	            $code = unserialize($code);
	            if(is_array($code)){
	                update_option('vibe_customizer',$code);
	            }
	        }
	    }
	    
	    // Setup Menus
		$wplms_menus = array(
			'top-menu'=>1,
			'main-menu'=>'main-menu',
			'mobile-menu'=>'main-menu',
			'footer-menu'=>'footermenu',
		);
		// End HomePage setup
		
		//Set Menus to Locations
		$vibe_menus  = wp_get_nav_menus();
		if(!empty($vibe_menus) && !empty($wplms_menus)){ // Check if menus are imported
			//Grab Menu values
			global $wpdb;
			foreach($wplms_menus as $key=>$menu_item){
				$term_id = $wpdb->get_var( $wpdb->prepare( "SELECT term_id FROM {$wpdb->terms} WHERE slug = %s LIMIT 1;", "{$menu_item}" ) );	
				if(isset($term_id) && is_numeric($term_id)){
					$wplms_menus[$key]=$term_id;
				}else{
					unset($wplms_menus[$key]);
				}
			}
			//update the theme
			set_theme_mod( 'nav_menu_locations', $wplms_menus);
			$menu_id = $wpdb->get_var($wpdb->prepare("SELECT post_id from {$wpdb->postmeta} WHERE meta_key=%s AND meta_value IN(SELECT id from {$wpdb->posts} WHERE post_name=%s AND post_type=%s) LIMIT 0,1",'_menu_item_menu_item_parent','courses','nav_menu_item'));
			if(!empty($menu_id)){
				update_post_meta($menu_id,'_menu_item_sidebar','MegaMenu');
				update_post_meta($menu_id,'_menu_item_columns','4');
				update_post_meta($menu_id,'_menu_item_menu_width','100%');
			}
			

		}
		//End Menu setup
		$forms = array(
		    'main' => array(
		            'settings'=> array(
		                    'hide_username' => 'on',
		                    'password_meter' => 'on',
		                    'google_captcha' => 'on',
		                    'custom_activation_mail' => '10',
		                    'default_role' => '',
		                    'save_form_settings' => 'Save',
		                ),

		            'fields' => array( 'Name'),

		        ),
			);
		update_option('wplms_registration_forms',$forms);


		//terms metas :
		$course_cats = get_terms('course-cat', array('hide_empty' => false));
		$thumbs_array = array(402,403,404,405,406,407);
		foreach ($course_cats as $key => $term) {
			$i++;
			update_term_meta($term->term_id,'course_cat_order',$i);
			update_term_meta($term->term_id,'course_cat_thumbnail_id',$thumbs_array[$key]);
		}

	}

	function add_custom_users(){

		


		$social_field_group=array(
					'name' => 'Social Profiles',
					'description' => 'Links to social profiles'
				);
		$social_field_group_id=xprofile_insert_field_group($social_field_group);
		$fields = array(
					array(
						'field_group_id'=>$social_field_group_id,
						'type'=>'url',
						'name'=>'Facebook',
						'description'=>'Facebook profile link'
					),
					array(
						'field_group_id'=>$social_field_group_id,
						'type'=>'url',
						'name'=>'Twitter',
						'description'=>'Twitter profile link'
					),
				);

		foreach($fields as $field){
			xprofile_insert_field($field);	
		}
		
		$users = array(
			array(
					'username'=>'wplms_lynda',
					'password'=>'lynda',
					'email'=>'vibethemes@gmail.com',
					'role'=>'instructor',
					'fields'=>array(
						'Location'=>'New York',
						'Speciality'=>'Design',
						'Bio'=>'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters English.',
						'Facebook'=>'#',
						'Twitter'=>'#',
					),
				),
			array(
					'username'=>'Parker',
					'password'=>'parker',
					'email'=>'support@vibethemes.com',
					'role'=>'instructor',
					'fields'=>array(
						'Location'=>'New York',
						'Speciality'=>'Design',
						'Bio'=>'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters English.',
						'Facebook'=>'#',
						'Twitter'=>'#',
					),
				),
			array(
					'username'=>'Simon',
					'password'=>'simon',
					'email'=>'sample@sample.com',
					'role'=>'instructor',
					'fields'=>array(
						'Location'=>'New York',
						'Speciality'=>'Literature',
						'Bio'=>'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters English.',
						'Facebook'=>'#',
						'Twitter'=>'#',
					),
				),
			array(
					'username'=>'Leon',
					'password'=>'leon',
					'email'=>'sample@example.com',
					'role'=>'instructor',
					'fields'=>array(
						'Location'=>'New York',
						'Speciality'=>'MAths',
						'Bio'=>'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters English.',
						'Facebook'=>'#',
						'Twitter'=>'#',
					),
				),
			);

		foreach($users as $user){
			$user_id = wp_insert_user(array('user_login'=>$user['username'],'user_pass'=>$user['password'],'user_email'=>$user['email'],'role'=>$user['role']));
			if(!is_wp_error($user_id) && function_exists('xprofile_set_field_data')){
				foreach($user['fields'] as $field=>$value){
					xprofile_set_field_data($field,$user_id,$value);
				}
			}
		}
	}

	function wplms_demo10_sidebars_widgets(){

		$sidebars_file = plugin_dir_path(__FILE__)."data/sidebars.txt";

		if(file_exists($sidebars_file)){
			$myfile = fopen($sidebars_file , "r") or die("Unable to open file!".$sidebars_file );
			while(!feof($myfile)) {
				$string = fgets($myfile);
			}
			fclose($myfile);
		    $code = base64_decode(trim($string)); 
		    if(is_string($code)){
		        $code = unserialize($code);
		        if(is_array($code)){
		        	update_option('sidebars_widgets',$code);
		        }
		    }
		}
		$widgets_file = plugin_dir_path(__FILE__)."data/widgets.txt";
		if(file_exists($widgets_file)){
			$myfile = fopen($widgets_file , "r") or die("Unable to open file!".$widgets_file );
			while(!feof($myfile)) {
				$string = fgets($myfile);
			}
			fclose($myfile);
	        $code = base64_decode(trim($string)); 
	        if(is_string($code)){
	            $code = unserialize($code);
	            if(is_array($code)){
	            	foreach($code as $key=>$option){
	            		update_option($key,$option);
	            	}
	            }
	        }
		}
	}
}

WPLMS_Demo10::init();